/**********************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: java.h,v 1.3 2008/01/25 10:47:07 ialelekov Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

#ifndef _JAVA_H_
#define _JAVA_H_

#include "tptp/TPTPSupportTypes.h"
#include "tptp/TPTPCommon.h"
#include "tptp/TPTPBaseTL.h"
#include "tptp/TPTPTypes.h"
#include "tptp/BaseTLLog.h"

#define CLASS_STRING					"java/lang/String"

#include <jni.h>

#ifdef __cplusplus
extern "C" {
#endif

extern JavaVM *_java_VM; /* The global JVM handle */

struct _tptpJavaJob;

typedef tptp_uint32 (tptpJavaJobImplementation)(struct _tptpJavaJob *job); /* Typedef for our Java job completion listener */

typedef struct _tptpJavaJob {
	TID threadHandle;
	JNIEnv *env;
	tl_state_data_t *stateData;
} tptpJavaJob;

/**
  * MACROS
  *
  */
#if defined __cplusplus && defined _HPUX
	#define ENV(e) e
	#define ENVPARM(e)
	#define ENVPARM1(e)
#else
	#define ENV(e) (*e)
	#define ENVPARM(e) e,
	#define ENVPARM1(e) e
#endif

#ifdef _WIN32
	#define ATTACH_THREAD(env) (*_java_VM)->AttachCurrentThread(_java_VM,  (void**)&env, NULL)
	#define DETACH_THREAD() (*_java_VM)->DetachCurrentThread(_java_VM)
#elif MVS
	#define ATTACH_THREAD(env) (*_java_VM)->AttachCurrentThread(_java_VM,  (void**)&env, NULL)
	#define DETACH_THREAD() (*_java_VM)->DetachCurrentThread(_java_VM)
#elif _HPUX
	#define ATTACH_THREAD(env) (_java_VM)->AttachCurrentThread((void**)&env, NULL)
	#define DETACH_THREAD() (_java_VM)->DetachCurrentThread()
#elif __OS400__
	#define ATTACH_THREAD(env) (*_java_VM)->AttachCurrentThread(_java_VM,  (void**)&env, NULL)
	#define DETACH_THREAD() (*_java_VM)->DetachCurrentThread(_java_VM)
#else
	#define ATTACH_THREAD(env) (*_java_VM)->AttachCurrentThread(_java_VM,  (void**)&env, NULL)
	#define DETACH_THREAD() (*_java_VM)->DetachCurrentThread(_java_VM)
#endif


/* Typedef for our JVM creation routine */
typedef jint (JNICALL *tptpCreateJavaVM)(JavaVM**, void**, void*);


/* Functions */
tptp_uint32 tptpCreateJavaVitualMachine(tl_state_data_t* stateData, tptp_string *classpath);
tptp_uint32 tptpSubmitJavaJob(tl_state_data_t* stateData, tptpJavaJobImplementation *jobImpl, BOOL asynchronous, TID *tid);
tptp_uint32 tptpDestroyJavaVirtualMachine(tl_state_data_t* stateData);

jclass		getcnvcls(JNIEnv *env, char *clsname, int clslen);
jmethodID	getmthdid(JNIEnv *env, jclass clsid, char *mthd, char *sig);
jclass		fndclsid(JNIEnv *env, char *clsname);

/** getnewstrutf **********************************************************************************
  * This function creates a new UTF8 string using the string given, taking care of platform-
  * dependent encoding on AS/400 and OS/390.
  *
  * @param env  the environment in which the search is to be performed
  * @param str  the content of the string to be created
  * @returns the Java string corresponding to the string given.
  */
jstring getnewstrutf(JNIEnv *env, char *str);

typedef struct {
	tptpJavaJobImplementation *fcn_ptr;
	tl_state_data_t* stateData;
} tptpJavaJobWrapper;


#ifdef __cplusplus
}
#endif


#endif
