/*******************************************************************************
 * Copyright (c) 2008, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel - Initial API and Implementation
 *
 * $Id: nativeFileServer.h,v 1.3 2010/02/16 16:17:17 jwest Exp $
 *
 *******************************************************************************/ 

#ifndef _NATIVE_FILE_SERVER
#define _NATIVE_FILE_SERVER

#ifdef _WIN32
	#define WIN32_LEAN_AND_MEAN
	#include <windows.h>
#endif

#include <string.h>

#ifdef _WIN32
	#include <direct.h>
#else
	#include <sys/stat.h>
	#include <sys/types.h>
#endif

#ifndef _WIN32
	#define INVALID_SOCKET (-1)
#endif

#include "tptp/TPTPTypes.h"
#include "tptp/TPTPSupportTypes.h"
#include "tptp/TransportSupport.h"
#include "tptp/TPTPBaseTL.h" 
#include "tptp/compatibility/RAComm.h" 
#include "ClientCTL.h"

#ifdef _WIN32
	#define  pathSeparatorCharacter '\\'
	#define  pathSeparator "\\"
#else
	#define  pathSeparatorCharacter '/'
	#define  pathSeparator "/"
#endif			

typedef struct {
	SOCKET      socket;
	char*		buffer;
	int 		bufferLength;
	tl_state_data_t* stateData;
} fs_connection_block_t;

#define DETERMINE_SERVER_REACH_COMMAND 1
#define DETERMINE_SERVER_REACH_COMMAND_STR "org.eclipse.hyades.internal.execution.core.file.dynamic.DetermineServerReachCommand"

#define GET_FILE_COMMAND 2
#define GET_FILE_COMMAND_STR "org.eclipse.hyades.internal.execution.core.file.dynamic.GetFileCommand"

#define PUT_FILE_COMMAND 3
#define PUT_FILE_COMMAND_STR "org.eclipse.hyades.internal.execution.core.file.dynamic.PutFileCommand"

#define DELETE_FILE_COMMAND 4
#define DELETE_FILE_COMMAND_STR "org.eclipse.hyades.internal.execution.core.file.dynamic.DeleteFileCommand"

#define DELETE_DIR_COMMAND 5
#define DELETE_DIR_COMMAND_STR "org.eclipse.hyades.internal.execution.core.file.dynamic.DeleteDirectoryCommand"

#define VALIDATE_DIR_COMMAND 6
#define VALIDATE_DIR_COMMAND_STR "org.eclipse.hyades.internal.execution.core.file.dynamic.ValidateDirectoryExistenceCommand"

#define QUERY_SERVER_STATUS_COMMAND 7
#define QUERY_SERVER_STATUS_COMMAND_STR "org.eclipse.hyades.internal.execution.core.file.dynamic.QueryServerStatusCommand"

#define MDFY_PERMISSION_COMMAND 8
#define MDFY_PERMISSION_COMMAND_STR "org.eclipse.hyades.internal.execution.core.file.dynamic.ModifyPermissionCommand"

#define LIST_CONTENT_COMMAND 9
#define LIST_CONTENT_COMMAND_STR "org.eclipse.hyades.internal.execution.core.file.dynamic.ListContentCommandCommand"

#define OPEN_CONTROL_DIALOG "org.eclipse.hyades.execution.core.loader.ScopedChannelClassLoader$AbstractControlDirective$BeginControlDirective"
#define CLOSE_CONTROL_DIALOG "org.eclipse.hyades.execution.core.loader.ScopedChannelClassLoader$AbstractControlDirective$EndControlDirective"

#define FS_TRUE		127		// java.lang.Boolean.MAX_VALUE
#define	FS_FALSE	-128	// java.lang.Boolean.MIN_VALUE

extern int readInt (SOCKET socket, int* value);
extern char* readString(SOCKET socket);

extern int writeByte(SOCKET socket, int byte);
extern int writeBoolean(SOCKET socket, int d);
extern int writeInt (SOCKET socket, int v);
extern int writeString(SOCKET socket, char* buffer);
extern int writeStrings(SOCKET socket, char** array, int len);

extern char* readStringIntoBuffer(fs_connection_block_t* con);
extern int readFile(fs_connection_block_t* con, char* fileName);

extern int writeFile(fs_connection_block_t* con, char* fileName);

extern int openControlDialog(fs_connection_block_t* con);
extern int closeControlDialog(fs_connection_block_t* con);

extern THREAD_USER_FUNC_RET_TYPE startNativeFileServer(LPVOID args);

#endif
