/**********************************************************************
* Copyright (c) 2006, 2009 IBM Corporation and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* $Id: user.h,v 1.6 2009/04/14 20:33:28 jwest Exp $
* 
* Contributors: 
* IBM - Initial API and implementation
**********************************************************************/

#ifndef _SECURITY_H_
#define _SECURITY_H_

#include "tptp/TPTPConfig.h"
#include "tptp/TPTPSupportTypes.h"
#include "ClientCTL.h"

#if defined(_WIN32)
	#include <winsock2.h>
	#include <windows.h>
#elif defined(__MVS__)
	#include <pwd.h>
#elif defined(__OS400__)
	#include <mih/cipher.h>
	#include <pointer.h>
	#include <qsyrupwd.h>
	#include <qusec.h>
	#include <string.h>
	#include <ctype.h>
	#include <qsygetph.h>

	typedef _Packed struct error_code_t {
		long int bytesProvided;
		long int bytesAvailable;
		char exceptionID[7];
		char reserved1[1];
		char data[64];
	} error_code_t;

#else
	#include <stdio.h>
	#include <signal.h>
	#include <unistd.h>
	#include <stdlib.h>
	#include <sys/wait.h>
#endif

#ifdef __OS400__
typedef _Packed struct error_code_t {
	tptp_int32 bytesProvided;
	tptp_int32 bytesAvailable;
	tptp_string exceptionID[7];
	tptp_string reserved1[1];
	tptp_string data[64];
} error_code_t;
#endif /* __OS400__ */


/** tptpAuthenticateUser ***************************************************************************
  * This function determines whether a user has access to the system
  *
  * @param username - the username to authenticate
  * @param password - the password to authenticate
  * @returns TRUE if the authentication is successful,
  *          FALSE otherwise.
  */
BOOL tptpAuthenticateUser(tl_state_data_t* stateData, tptp_string *username, tptp_string *password);


/** tptpAuthenticateUser ***************************************************************************
  * This function determines whether a user has access to the agent controller.
  *
  * @param username - the username to authenticate
  * @param userList - comma separated list of allowed user
  * @returns TRUE if the check is successful,
  *          FALSE otherwise.
  */
BOOL tptpUserAllowed(tl_state_data_t* stateData, tptp_string *username, tptp_string *userType, tptp_string *userList);

#endif

