/**********************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: tptpConfig.cpp,v 1.3 2008/02/06 12:41:00 ialelekov Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

#include "tptpConfig.h"
#include "tptpJSSE.h"
#include <string.h>

static char* jsseKsFilename = NULL;
static char* jsseKsPassword = NULL;
static char* jsseServerPort = NULL;

char* getConfigValue(const char* name) {

	if (!strcmp(KEYSTORE_FILENAME,name)) {
		return jsseKsFilename;
	}

	if (!strcmp(KEYSTORE_PASSWORD,name)) {
		return jsseKsPassword;
	}

	if(!strcmp(KEYSTORE_SERVER_PORT, name)) {
		return jsseServerPort;
	}

	return NULL;

}




void setConfigValue(const char* name, const char* value) {

	char ** target = NULL;

	// printf("(%s) -> (%s)\n", name, value);

	if (!strcmp(KEYSTORE_FILENAME,name)) target = &jsseKsFilename;
	
	if (!strcmp(KEYSTORE_PASSWORD,name)) target = &jsseKsPassword;
	if (!strcmp(KEYSTORE_SERVER_PORT,name)) target = &jsseServerPort;
	
	if(target == NULL) {
		return;
	}

	if(value == NULL) {
		(*target) = NULL;
		return;
	}

	if((*target) != NULL) {
		free(*target);
	}

	(*target) = (char*) malloc(strlen(value)+1);
	strcpy((*target), value);		
	
}
