/*******************************************************************************
 * Copyright (c) 2007, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Igor Alelekov, Intel - Initial implementation
 *
 * $Id: tptpJSSELog.h,v 1.3 2008/02/28 03:55:27 jkubasta Exp $
 *
 *******************************************************************************/ 

#ifndef _JSSESSLLOG_H_

#define _JSSESSLLOG_H_

/*****************************************************************************************************
 *                                                                                                   *
 * To use the log macros in TPTPLog.h, the following must be defined:                                *
 *                                                                                                   *
 *    RESOLVE_LOG_EVENT_FUNC(p)      resolves to a logEvent function pointer                         *
 *    RESOLVE_INITIAL_PARAM(p)       if a parameter is needed before the subcomponent, this macro    *
 *                                     should give that parameter, including the separating comma    *
 *                                     if no such parameter is needed this macro should resolve to   *
 *                                   white space                                                     *
 *    TPTP_LOG_SUBCOMPONENT_NAME(p)  the name of the subcomponent to appear in the log file          *
 *    TPTP_LOG_INSTANCE_ID(p)        an instance ID for the log file                                 *
 *                                                                                                   *
 *****************************************************************************************************/

/* These definitions assume 'p' will point to a server_block_t as defined in SocketListener.h */

#define RESOLVE_LOG_EVENT_FUNC(p)     p->logEventEntry

#define RESOLVE_INITIAL_PARAM(p)      p->cmo, /* Note: this trailing comma is required */

#define TPTP_LOG_SUBCOMPONENT_NAME(p) "tptpJSSE"

#define TPTP_LOG_INSTANCE_ID(p)       0

/* Do not move this include, it requires the above definitions */

#include "tptp/TPTPLog.h"

#endif /* _JSSESSLLOG_H_ */
