/*******************************************************************************
 * Copyright (c) 2005,2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hoang M Nguyen, Intel - Initial API and Implementation
 *
 * $Id: NamedPipeListener.h,v 1.15 2006/08/28 18:41:45 akaylor Exp $
 *
 *******************************************************************************/ 



#ifndef _namedPipeListener_H
#define _namedPipeListener_H

#include "tptp/NamedPipeTL.h"
#include "tptp/TPTPSupportTypes.h"
#include "tptp/TPTPMessageHeader.h"

#include "tptp/hashtable.h"
#include "tptp/TPTPUtils.h"


/* The default name of the master named pipe */
#define PIPE_DEFAULT_ADDRESS "acmaster"

#define NAMED_PIPE_LISTENER_OBJECT_ID  20003

#define TPTP_NAMED_PIPE_PARTIAL_MESSAGE   -1


/* main thread data block */
typedef struct {
	int                     threadStatus ;
	HANDLE                  serverPipe ;
	tptp_object*            cmo;
	transport_layer_data_t	agentControllerDataBlk ;
	processMessage_ptr_t    processMessage;
	tptp_object*            nexto;

	/* hash table of connections for easy and fast search */
    HashTable               *  connectionTable ;

	char   fullPipeName[TPTP_MAX_NAMED_PIPE_LENGTH] ;
} server_block_t ;

typedef server_block_t * server_block_ptr_t ;


/**
 *********************************************************
 *
 * @brief
 *    create an instance of the named pipe listener
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
tptp_int32 createNamedPipeListener(tptp_object* cmo, transport_layer_data_t * pTransportData, tptp_object* tlo) ;


/**
 *********************************************************
 *
 * @brief
 *    destroy an instance of the named pipe listener
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
tptp_int32 destroyNamedPipeListener(tptp_object* tlo) ;


/**
 *********************************************************
 *
 * @brief
 *    set the function for forwarding messages
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
tptp_int32 setNamedPipeProcessMessageFunc( server_block_t* pServerData, tptp_object* nexto, processMessage_ptr_t func);


/**
 *********************************************************
 *
 * @brief
 *    start the main thread listening to incoming named pipe connection
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
tptp_int32 startNamedPipeListener(server_block_t* pServerData);


/**
 *********************************************************
 *
 * @brief
 *    stop the server named pipe. Stop accepting connection requests.
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
tptp_int32   stopNamedPipeListener(server_block_t* pServerData) ;


/**
 *********************************************************
 *
 * @brief
 *    terminate the given connection
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
tptp_int32   terminateNamedPipeConnection(server_block_t* pServerData, tptp_uint32  connectionID);


/**
 *********************************************************
 *
 * @brief
 *    send a given message to the given destination (identified by connection id)
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
tptp_int32   sendNamedPipeMessage( server_block_t* pServerData, tptp_uint32 connectionID, tptp_uint32 size, char * pCmdBlock) ;



/**
 *********************************************************
 *
 * @brief
 *    common interface to set up the data path between source and destination
 *    (named pipe).
 *
 * @return
 *    0 - Success
 *    negative - Not supported
 *********************************************************/

tptp_int32 setNamedPipeIncomingDataFunc( server_block_t* pServerData, tptp_uint32 connectionID, tptp_uint32 partnerID, tptp_object* partner, sendData_ptr_t newDataFunc ) ;


/**
 *********************************************************
 *
 * @brief
 *    send a given message to the given destination (identified by connection id)
 *
 * @return
 *    Negative - Error
 *    0 - Named pipe is closed gracefully
 *    Positive - the number of bytes that have been sent
 *********************************************************/
tptp_int32 sendNamedPipeData(server_block_t* pServerData, tptp_uint32 connectionID, tptp_uint32 dataSize, tptp_string* pDataBlock) ;



/* connection request data block */
typedef struct request_block {
	HANDLE              agentPipe;    
	tptp_uint32         connectionId ;
	int                 connectionType ;
	server_block_ptr_t  pServerData ;
	PID                 processID4Console ;
	char   fullPipeName[TPTP_MAX_NAMED_PIPE_LENGTH] ;

	sendData_ptr_t      pSendFunc ;
	tptp_object*        partner;
	unsigned int        connectionPartnerID ;

	unsigned int        replyConnId ; /* this is for console support */
	HANDLE              consoleInputPipe;    

	Semaphore_t         hasProcessIdSemaphore ;

} request_block_t ;

typedef request_block_t * request_block_ptr_t ;


/*  data block for console thread */
typedef struct console_thread_block {
	request_block_ptr_t  pRequestBlk ;
	int                  consoleType ;
	int                  threadStatus ;
} console_thread_block_t ;

typedef console_thread_block_t * console_thread_block_ptr_t ;


#endif /* _namedPipeListener_H */

