
################################################################################
#                                       
#  makefile:  namedPipeTL project       
#                                       
# $Id: NamedPipeTL_aix.make,v 1.1 2009/07/10 00:11:34 jwest Exp $                                  
################################################################################


#-----------------------------------
#
#   Customizable section
#
#   - The TARGETREALNAME variable specifies the name of the library file
#     that will be generated, this includes a base (TARGETLIB) plus	a 
#     version number plus a minor number plus a release number
#   - The TARGETSONAME variable specifies a file name that has just the
#     library name plus the major version number
#   - The TARGETLIB variable specifies the base library name
#   - The TARGETSONAME and TARGETLIB are generated as symbolic links
#     when the library is built
#
#-----------------------------------
TARGET         :=  libnamedPipeTL
TARGETDIR      :=  ../../../lib

if [ x$VERSIONNUM = x ]; then export VERSIONNUM=0; fi
if [ x$MINORNUM = x ]; then export MINORNUM=0; fi
if [ x$RELEASENUM = x ]; then export RELEASENUM=0; fi

TARGETLIB      :=  $(TARGET).so
TARGETSONAME   :=  $(TARGETLIB).$(VERSIONNUM)
TARGETREALNAME :=  $(TARGETSONAME).$(MINORNUM).$(RELEASENUM)


#-----------------------------------
#   list of additional INCLUDE directories to search headers from
#      (separated by blanks)
#-----------------------------------
INCLUDEDIRS    :=  ../RACommon ../RASharedMemory ../RASocket . ../../../include


#-----------------------------------
#   list of additional libraries to be linked with
#      (separated by blanks)
#-----------------------------------
LIBS       :=  dl tptpUtils transportSupport

#-----------------------------------
#   list of additional library directories to search from
#      (separated by blanks)
#-----------------------------------
LIBDIRS    :=  ../../../lib


#-----------------------------------
#
#   Compiler options
#
#      -g       produce debug info
#      -Wall    enable all types of warnings
#      -O3      highest level of code optimization
#      -fPIC    generate position-independent code (PIC).
#               This is required for building shared library.
#      -c       compile only
#
#   Linking options
#
#       -Wl       pass options to linker
#       -shared   produce shared library
#       -L        add the given directory to the search path for libraries
#
#-----------------------------------

CFLAGS     :=  $(C_FLAGS) $(DEBUGABLE) $(DEBUGFLAGS) -qflag=i:i $(SIXTYFOURBIT) $(OPTIMIZABLE) -qpic=large $(addprefix -I,$(INCLUDEDIRS))  -D_AIX

CXXFLAGS   :=  $(CFLAGS)

LINKOPTS   :=  $(L_FLAGS) $(DEBUGABLE) $(DEBUGLIBS) $(MKSHARE) -G $(SIXTYFOURBIT) -o $(TARGETDIR)/$(TARGETREALNAME) $(addprefix -L,$(LIBDIRS))


#-----------------------------------
#   general commands and options
#-----------------------------------

CC          :=  xlc_r
CXX         :=  $(CC)

SOURCE     :=  $(wildcard *.c)  $(wildcard *.cpp)

OBJS       :=  $(patsubst %.c,%.o,$(patsubst %.cpp,%.o,$(SOURCE)))

REMOVEFILE :=  rm -f
CREATELINK :=  ln -sf


#-----------------------------------
#   "make" rules
#-----------------------------------

.PHONY : default everything objs clean veryclean rebuild $(TARGET)


default : $(TARGET)


objs : $(OBJS)


clean :
	$(REMOVEFILE) *.o


veryclean: clean
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETLIB)
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETSONAME)
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETREALNAME)


rebuild: veryclean everything


$(TARGET) : $(OBJS)
	$(CC) $(LINKOPTS) $(OBJS) $(addprefix -l,$(LIBS))
	$(CREATELINK) $(TARGETREALNAME)  $(TARGETDIR)/$(TARGETSONAME)
	$(CREATELINK) $(TARGETSONAME)    $(TARGETDIR)/$(TARGETLIB)

