/*******************************************************************************
 * Copyright (c) 2005, 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hoang M Nguyen, Intel - Initial API and Implementation
 *
 * $Id: SharedMemListener.h,v 1.9 2007/04/13 16:12:55 jkubasta Exp $
 *
 *******************************************************************************/ 



#ifndef _SharedMemListener_H
#define _SharedMemListener_H

#include <stdio.h>

#include "tptp/TransportSupport.h"

#include "tptp/SharedMemTL.h"

#include "tptp/hashtable.h"


#define SHARED_MEM_LISTENER_OBJECT_ID  20002

#define CONNECT_TIMEOUT	60	/* timeout for incoming connections, seconds */
#define FLUSHER_TIMEOUT	4	/* seconds */


/* main thread data block */
typedef struct {

	int                    threadStatus ;

	mem_map_block_t         serverMemInfo ;

	tptp_object*            cmo;

	transport_layer_data_t	agentControllerDataBlk ;

	processMessage_ptr_t    processMessage;
	tptp_object*            nexto;

	/* hash table of connections for easy and fast search */
    HashTable               *  connectionTable ;

	char*	sharedMemName;

} server_block_t ;


typedef server_block_t * server_block_ptr_t ;

/**
 *********************************************************
 *
 * @brief
 *    create a new instance of a shared mem handler
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/

tptp_int32 createSharedMemListener(tptp_object* cmo, transport_layer_data_t * pTransportData, tptp_object* tlo) ;


/**
 *********************************************************
 *
 * @brief
 *    destroy an instance of a shared mem handler
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/

tptp_int32 destroySharedMemListener(tptp_object* tlo);


/**
 *********************************************************
 *
 * @brief
 *    set the function for forwarding messages
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/

tptp_int32 setSharedMemProcessMessageFunc(server_block_t* pServerData, tptp_object* nexto, processMessage_ptr_t func) ;


/**
 *********************************************************
 *
 * @brief
 *    create a new running thread to handle shared mem connections
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/

tptp_int32 startSharedMemListener(server_block_t* pServerData) ;


/**
 *********************************************************
 *
 * @brief
 *    stop the shared memory server. Stop accepting connection requests.
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/

tptp_int32 stopSharedMemListener(server_block_t* pServerData) ;


/**
 *********************************************************
 *
 * @brief
 *    terminate the given connection
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 *********************************************************/
tptp_int32 terminateSharedMemConnection(server_block_t* pServerData, tptp_uint32 connectionID);


/**
 *********************************************************
 *
 * @brief
 *    common interface to set up the data path between source and destination
 *    (socket).
 *
 * @return
 *    0 - Success
 *    negative - Not supported
 *********************************************************/

tptp_int32 setSharedMemIncomingDataFunc( server_block_t* pServerData, tptp_uint32 connectionID, tptp_uint32 partnerID, tptp_object* partner, sendData_ptr_t newDataFunc ) ;




/**
 *********************************************************
 *
 * @brief
 *    send a given message to the given destination (identified by connection id)
 *
 * @return
 *    Negative - Error
 *    0 - Socket is closed gracefully
 *    Positive - the number of bytes that have been sent
 *********************************************************/
tptp_int32   sendSharedMemData(server_block_t* pServerData, tptp_uint32 connectionID, tptp_uint32 cmdSize, tptp_string* pDataBlock) ;



/* connection request data block */
typedef struct request_block {
	int                 threadStatus ;
	int                 flags ;
	char                uuid[1024] ;
	char                dataUUID[1024] ;
	mem_map_block_t     agentMemInfo ;
	mem_map_block_t     dataMemInfo ;
	int                 connectionId ;
	server_block_ptr_t  pServerData ;

	int                 connectionType ;
	sendData_ptr_t      pSendFunc ;
	tptp_object*        partner;
	int                 connectionPartnerID ;
	int					connected;

} request_block_t ;

typedef request_block_t * request_block_ptr_t ;


#endif /* _SharedMemListener_H */

