/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Igor Alelekov, Intel - Initial API and implementation
 *
 * $Id: SSLSupport.h,v 1.1 2008/01/14 07:49:57 ialelekov Exp $
 *******************************************************************************/ 

#ifndef SSLSUPPORT_H
#define SSLSUPPORT_H

#include "SocketListener.h"
#include "SSLTypes.h"

extern int ssl_init(server_block_ptr_t pServerData);
extern ssl_socket_t ssl_accept();
extern int ssl_handshake(ssl_socket_t ssl_socket);
extern int ssl_read(ssl_socket_t ssl_socket, char* buffer, int length);
extern int ssl_write(ssl_socket_t ssl_socket, char* buffer, int length);
extern int ssl_close(ssl_socket_t ssl_socket);
extern int ssl_reset();
extern char* ssl_getValue(const char* name);
extern void ssl_setValue(const char* name, const char* value);
extern char* ssl_getProviderName();

#endif
