/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Igor Alelekov, Intel - Initial API and implementation
 *
 * $Id: SSLTypes.h,v 1.1 2008/01/14 07:49:57 ialelekov Exp $
 *******************************************************************************/ 

#ifndef _SSLTypes_H
#define _SSLTypes_H

typedef void* ssl_socket_t;

/* Function names to be imported */
#define SSL_INIT 		"sslInit"
#define SSL_ACCEPT 		"sslAccept"
#define SSL_HANDSHAKE 	"sslHandshake"
#define SSL_READ 		"sslRead"
#define SSL_WRITE 		"sslWrite"
#define SSL_CLOSE 		"sslClose"
#define SSL_RESET 		"sslReset"
#define SSL_GET_VALUE 	"sslGetValue"
#define SSL_SET_VALUE 	"sslSetValue"
#define SSL_GET_PROVIDER_NAME "sslGetProviderName"

/* SSL function types */
typedef int (*ssl_provider_init_t)();
typedef ssl_socket_t (*ssl_provider_accept_t)();
typedef int (*ssl_provider_handshake_t)();
typedef int (*ssl_provider_read_t)();
typedef int (*ssl_provider_write_t)();
typedef int (*ssl_provider_close_t)();
typedef int (*ssl_provider_reset_t)();
typedef char* (*ssl_provider_getValue_t)(const char*);
typedef void (*ssl_provider_setValue_t)(const char*, const char*);
typedef char* (*ssl_provider_getName_t)();

#endif
