/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hoang M Nguyen, Intel - Initial API and Implementation
 *    IBM - Portions of old RAC code (brought over by Hoang M Nguyen)
 *
 * $Id
 *
 *******************************************************************************/ 

#include "tptp/TransportSupport.h"
#include "tptp/NoLog.h"


HANDLE createReadOnlyNamedPipe(const char *pNameSpace, const char *pPipeName, int bInheritHandle)
{
	return (createGeneralNamedPipe(pNameSpace, pPipeName, TPTP_PIPE_READ_ONLY, bInheritHandle)) ;
}

HANDLE createWriteOnlyNamedPipe(const char *pNameSpace, const char *pPipeName, int bInheritHandle)
{
	return (createGeneralNamedPipe(pNameSpace, pPipeName, TPTP_PIPE_WRITE_ONLY, bInheritHandle)) ;
}

HANDLE createDuplexNamedPipe(const char *pNameSpace, const char *pPipeName, int bInheritHandle)
{
	return (createGeneralNamedPipe(pNameSpace, pPipeName, TPTP_PIPE_DUPLEX, bInheritHandle)) ;
}


HANDLE openReadOnlyNamedPipe(const char *pNameSpace, const char *pPipeName, int bInheritHandle)
{
	return (openGeneralNamedPipe(pNameSpace, pPipeName, TPTP_PIPE_READ_ONLY, bInheritHandle)) ;
}

HANDLE openWriteOnlyNamedPipe(const char *pNameSpace, const char *pPipeName, int bInheritHandle)
{
	return (openGeneralNamedPipe(pNameSpace, pPipeName, TPTP_PIPE_WRITE_ONLY, bInheritHandle)) ;
}

HANDLE openDuplexNamedPipe(const char *pNameSpace, const char *pPipeName, int bInheritHandle)
{
	return (openGeneralNamedPipe(pNameSpace, pPipeName, TPTP_PIPE_DUPLEX, bInheritHandle)) ;
}

HANDLE openNonCriticalWriteOnlyNamedPipe(const char *pNameSpace, const char *pPipeName, int bInheritHandle)
{
	return (openGeneralNamedPipe(pNameSpace, pPipeName, TPTP_PIPE_NC_WRITE_ONLY, bInheritHandle)) ;
}
