
################################################################################
#                                       
#  makefile:  transportSupport project  
#                                       
# $Id: TransportSupport_mac.make,v 1.1 2009/08/07 02:34:10 jwest Exp $                                  
################################################################################


#-----------------------------------
#
#   Customizable section
#
#   - The TARGETREALNAME variable specifies the name of the library file
#     that will be generated, this includes a base (TARGETLIB) plus	a 
#     version number plus a minor number plus a release number
#   - The TARGETSONAME variable specifies a file name that has just the
#     library name plus the major version number
#   - The TARGETLIB variable specifies the base library name
#   - The TARGETSONAME and TARGETLIB are generated as symbolic links
#     when the library is built
#
#-----------------------------------
TARGET         :=  libtransportSupport
TARGETDIR      :=  ../../../lib

if [ x$VERSIONNUM = x ]; then export VERSIONNUM=0; fi
if [ x$MINORNUM = x ]; then export MINORNUM=0; fi
if [ x$RELEASENUM = x ]; then export RELEASENUM=0; fi

TARGETLIB      :=  $(TARGET).dylib
TARGETSONAME   :=  $(TARGETLIB).$(VERSIONNUM)
TARGETREALNAME :=  $(TARGETSONAME).$(MINORNUM).$(RELEASENUM)


#-----------------------------------
#   list of additional INCLUDE directories to search headers from
#      (separated by blanks)
#-----------------------------------
INCLUDEDIRS    :=  ../RACommon ../RASharedMemory ../RASocket .  ../../../include /System/Library/Frameworks/JavaVM.framework/Versions/CurrentJDK/Headers/


#-----------------------------------
# Check if compiling on EM64T machine, -fPIC compiler option
# is required to compile this project

UNAME = $(shell uname -s)
MNAME = $(shell uname -m)

ifeq ($(UNAME), Linux)
	ifeq ($(MNAME), x86_64)
		USE_FPIC_OPTION = -fPIC
	endif
endif
#-----------------------------------

#-----------------------------------
#   list of additional libraries to be linked with
#      (separated by blanks)
#-----------------------------------
LIBS       :=  dl tptpUtils hcclco hcclsm hccls

#-----------------------------------
#   list of additional library directories to search from
#      (separated by blanks)
#-----------------------------------
LIBDIRS    :=  ../../../lib


#-----------------------------------
#
#   Compiler options
#
#      -g       produce debug info
#      -Wall    enable all types of warnings
#      -O3      highest level of code optimization
#      -fPIC    generate position-independent code (PIC).
#               This is required for building shared library.
#      -c       compile only
#
#   Linking options
#
#       -Wl                              pass options to linker
#       -dynamiclib                      produce dynamic library (ie shared library)
#       -undefined dynamic_lookup        look for undefined symbols at runtime
#
#-----------------------------------

DEFINES    := -DSQLUNIX -DSQLLinux -DENW -DREENTRANT -D_REENTRANT -DCONFIG_X86_CMPXCHG

# Removed the compiler option -fPIC due to an error related to BREG registers
# while reloading asm, which appeared after adding some code to validate the
# shared memory system settings for max value (Bug 129276). It compiled fine
# after removing -fPIC option from CFLAGS list. This option is required for EM64T

CFLAGS     :=  $(C_FLAGS) $(DEBUGABLE) -Wall $(OPTIMIZABLE) $(USE_FPIC_OPTION) $(addprefix -I,$(INCLUDEDIRS)) $(DEFINES)

CXXFLAGS   :=  $(CFLAGS)

LINKOPTS   :=  $(L_FLAGS) $(DEBUGABLE) -undefined dynamic_lookup -dynamiclib -o $(TARGETREALNAME) $(addprefix -L,$(LIBDIRS))


#-----------------------------------
#   general commands and options
#-----------------------------------

CC          :=  gcc
CXX         :=  $(CC)

SOURCE     :=  $(wildcard *.c)  $(wildcard *.cpp)

OBJS       :=  $(patsubst %.c,%.o,$(patsubst %.cpp,%.o,$(SOURCE)))

REMOVEFILE :=  rm -f
CREATELINK :=  ln -sf


#-----------------------------------
#   "make" rules
#-----------------------------------

.PHONY : default everything objs clean veryclean rebuild $(TARGET)


default : $(TARGET)


objs : $(OBJS)


clean :
	$(REMOVEFILE) *.o


veryclean: clean
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETLIB)
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETSONAME)
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETREALNAME)


rebuild: veryclean everything


$(TARGET) : $(OBJS)
	$(CC) $(LINKOPTS) $(OBJS) $(addprefix -l,$(LIBS))
	mv $(TARGETREALNAME) $(TARGETDIR)/$(TARGETREALNAME)
	$(CREATELINK) $(TARGETREALNAME)  $(TARGETDIR)/$(TARGETSONAME)
	$(CREATELINK) $(TARGETSONAME)    $(TARGETDIR)/$(TARGETLIB)
	 $(CREATELINK) $(TARGETREALNAME)  $(TARGETDIR)/$(TARGET).jnilib
