
################################################################################
#                                       
#  makefile:  transportSupport project  
#                                       
# $Id: TransportSupport_zos.make,v 1.1 2009/08/26 14:46:10 jwest Exp $                                  
################################################################################


#-----------------------------------
#
#   Customizable section
#
#   - The TARGETREALNAME variable specifies the name of the library file
#     that will be generated, this includes a base (TARGETLIB) plus	a 
#     version number plus a minor number plus a release number
#   - The TARGETSONAME variable specifies a file name that has just the
#     library name plus the major version number
#   - The TARGETLIB variable specifies the base library name
#   - The TARGETSONAME and TARGETLIB are generated as symbolic links
#     when the library is built
#
#-----------------------------------
TARGET         :=  libtransportSupport
TARGETDIR      :=  ../../../lib

ifeq (x$(VERSIONNUM),x)
    export VERSIONNUM=0
endif
ifeq (x$(MINORNUM),x)
    export MINORNUM=0
endif
ifeq (x$(RELEASENUM),x)
    export RELEASENUM=0
endif

TARGETLIB      :=  $(TARGET).so
TARGETSONAME   :=  $(TARGETLIB).$(VERSIONNUM)
TARGETREALNAME :=  $(TARGETSONAME).$(MINORNUM).$(RELEASENUM)


#-----------------------------------
#   list of additional INCLUDE directories to search headers from
#      (separated by blanks)
#-----------------------------------
INCLUDEDIRS    :=  ../RACommon ../RASharedMemory ../RASocket .  ../../../include ${JAVA_HOME}/include ${JAVA_HOME}/include/linux


#-----------------------------------
# Check if compiling on EM64T machine, -fPIC compiler option
# is required to compile this project

UNAME = $(shell uname -s)
MNAME = $(shell uname -m)

ifeq ($(UNAME), Linux)
	ifeq ($(MNAME), x86_64)
		USE_FPIC_OPTION = -fPIC
	endif
endif
#-----------------------------------

#-----------------------------------
#   list of additional libraries to be linked with
#      (separated by blanks)
#-----------------------------------
LIBS       :=  ../../shared/TPTPUtil/libtptpUtils.*.x ../RACommon/libhcclco.*.x ../RASharedMemory/libhcclsm.*.x ../RASocket/libhccls.*.x

#-----------------------------------
#   list of additional library directories to search from
#      (separated by blanks)
#-----------------------------------
LIBDIRS    :=  ../../../lib


#-----------------------------------
#
#   Compiler options
#
#      -g       produce debug info
#      -Wall    enable all types of warnings
#      -O3      highest level of code optimization
#      -fPIC    generate position-independent code (PIC).
#               This is required for building shared library.
#      -c       compile only
#
#   Linking options
#
#       -Wl       pass options to linker
#       -shared   produce shared library
#       -L        add the given directory to the search path for libraries
#
#-----------------------------------

DEFINES    :=  -DSQLUNIX -DENW -DREENTRANT -D_REENTRANT -DCONFIG_X86_CMPXCHG -D_OPEN_SYS_SOCK_IPV6

# Removed the compiler option -fPIC due to an error related to BREG registers
# while reloading asm, which appeared after adding some code to validate the
# shared memory system settings for max value (Bug 129276). It compiled fine
# after removing -fPIC option from CFLAGS list. This option is required for EM64T

CXXFLAGS   :=  $(C_FLAGS) $(DEBUGABLE) $(DEBUGFLAGS) -qflag=i $(OPTIMIZABLE) $(addprefix -I,$(INCLUDEDIRS)) -D_OS390 -D_UNIX03_THREADS -DMVS=1 -D_XOPEN_SOURCE_EXTENDED=1 -D_POSIX_SOURCE -D_UNIX03_SOURCE $(DEFINES) -W c,$(SIXTYFOURBIT)CSECT,NOLOCALE,LANGLVL\(EXTENDED\),LONGNAME,DLL,EXPORTALL,TARGET\(zOSV1R9\),XPLINK

CFLAGS     :=  $(CXXFLAGS),SSCOMM,RENT

LINKOPTS   :=  $(L_FLAGS) $(DEBUGABLE) $(DEBUGLIBS) -W l,$(SIXTYFOURBIT)DLL,XPLINK,AMODE=$(AMODEBIT),RMODE=ANY,CALL,REUS=RENT -o $(TARGETDIR)/$(TARGETREALNAME) $(addprefix -L,$(LIBDIRS))


#-----------------------------------
#   general commands and options
#-----------------------------------

CC          :=  xlc
CXX         :=  $(CC)

SOURCE     :=  $(wildcard *.c)  $(wildcard *.cpp)

OBJS       :=  $(patsubst %.c,%.o,$(patsubst %.cpp,%.o,$(SOURCE)))

REMOVEFILE :=  rm -f
CREATELINK :=  ln -sf


#-----------------------------------
#   "make" rules
#-----------------------------------

.PHONY : default everything objs clean veryclean rebuild $(TARGET)


default : $(TARGET)


objs : $(OBJS)


clean :
	$(REMOVEFILE) *.o *.x *.dbg


veryclean: clean
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETLIB)
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETSONAME)
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETREALNAME)


rebuild: veryclean everything


$(TARGET) : $(OBJS)
	$(CC) $(LINKOPTS) $(OBJS) $(LIBS)
	$(CREATELINK) $(TARGETREALNAME)  $(TARGETDIR)/$(TARGETSONAME)
	$(CREATELINK) $(TARGETSONAME)    $(TARGETDIR)/$(TARGETLIB)

