/*******************************************************************************
 * Copyright (c) 2005, 2009 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *	  Andy Kaylor, Intel - - Initial implementation
 *	  Spundun Bhatt (spundun@gmail.com), with the support and encouragement of the University of Southern California Information Sciences Institute Distributed Scalable Systems Division.
 * $Id: Base64Test.c,v 1.4 2009/08/07 00:52:01 jwest Exp $
 *******************************************************************************/ 
// Base64Test.cpp : Defines the entry point for the console application.
//

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "tptp\TPTPUtils.h"

#define NUM_TEST 10

int main() {
	char* raw[NUM_TEST] = {
		"Man is distinguished, not only by his reason, but by this singular passion from other animals, which is a lust of the mind, that by a perseverance of delight in the continued and indefatigable generation of knowledge, exceeds the short vehemence of any carnal pleasure.",
		"READY",
		"A",
		"AB",
		"ABC",
		"ABCD",
		"AB\nDE",
		"1",
		"12",
		"123"
	};

	char* raw_decode[1] = {
"TWFuIGlzIGRpc3Rpbmd1aXNoZWQsIG5vdCBvbmx5IGJ5IGhpcyByZWFzb24sIGJ1dCBieSB0aGlz\n\
IHNpbmd1bGFyIHBhc3Npb24gZnJvbSBvdGhlciBhbmltYWxzLCB3aGljaCBpcyBhIGx1c3Qgb2Yg\n\
dGhlIG1pbmQsIHRoYXQgYnkgYSBwZXJzZXZlcmFuY2Ugb2YgZGVsaWdodCBpbiB0aGUgY29udGlu\n\
dWVkIGFuZCBpbmRlZmF0aWdhYmxlIGdlbmVyYXRpb24gb2Yga25vd2xlZGdlLCBleGNlZWRzIHRo\n\
ZSBzaG9ydCB2ZWhlbWVuY2Ugb2YgYW55IGNhcm5hbCBwbGVhc3VyZS4A"
	};

	char* base64;
	char* buffer;
	int len_encode;
	int len_decode;
	int i;

	for(i = 0; i < NUM_TEST; i++) {
		printf("Raw = %s (%d bytes)\n", raw[i], strlen(raw[i]) + 1);

		/* Test encoding */
		len_encode = tptp_encodeBase64(raw[i], strlen(raw[i]) + 1, NULL, 0); /* NULL should be encoded as well */
		base64 = (char*)malloc(sizeof(char) * len_encode);
		tptp_encodeBase64(raw[i], strlen(raw[i]) + 1, base64, len_encode);
		printf("Encoded Base64 = %s (%d bytes)\n", base64, len_encode);

		/* Test decoding */
		len_decode = tptp_decodeBase64(base64, strlen(base64), NULL, 0);
		buffer = (char*)malloc(sizeof(char) * len_decode);
		tptp_decodeBase64(base64, strlen(base64), buffer, len_decode);
		printf("Decoded byte = %s (%d bytes)\n", buffer, len_decode);

		/* Verify if they are the same */
		if((0 == strcmp(raw[i], buffer)) && (len_decode == (strlen(raw[i]) + 1))) {
			printf("Conversion succeeded!\n");
		}
		else {
			printf("Conversion failed!\n");
		}
		printf("\n");

		free(base64);
		free(buffer);
	}

	/* Test decoding with newlines */
	printf("Test decode with newlines\n");
	printf("Encoded Base64 = %s\n", raw_decode[0]);
	len_decode = tptp_decodeBase64(raw_decode[0], strlen(raw_decode[0]), NULL, 0);
	buffer = (char*)malloc(sizeof(char) * len_decode);
	tptp_decodeBase64(raw_decode[0], strlen(raw_decode[0]), buffer, len_decode);
	printf("Decoded byte = %s\n", buffer);

	/* Verify if they are the same */
	if(0 == strcmp(raw[0], buffer)) {
		printf("Conversion succeeded!\n");
	}
	else {
		printf("Conversion failed!\n");
	}
	printf("\n");

	free(buffer);

}
