/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial implementation
 *
 * $Id: SampleAgentHandlerPlugin.java,v 1.1 2006/01/24 18:35:19 akaylor Exp $
 *
 *******************************************************************************/ 

package SampleAgentHandler;

import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.*;
import org.eclipse.core.resources.*;
import java.util.*;

/**
 * The main plugin class to be used in the desktop.
 */
public class SampleAgentHandlerPlugin extends AbstractUIPlugin {
	private AgentHandler m_agentHandler;
	//The shared instance.
	private static SampleAgentHandlerPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;
	
	/**
	 * The constructor.
	 */
	public SampleAgentHandlerPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
		m_agentHandler = new AgentHandler();
		try {
			resourceBundle= ResourceBundle.getBundle("SampleAgentHandler.SampleAgentHandlerPluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}
	
	public AgentHandler getAgentHandler()
	{
		return m_agentHandler;
	}

	/**
	 * Returns the shared instance.
	 */
	public static SampleAgentHandlerPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle= SampleAgentHandlerPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
}
