/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial implementation
 *
 * $Id: DisconnectAction.java,v 1.1 2006/01/24 18:35:19 akaylor Exp $
 *
 *******************************************************************************/ 

package SampleAgentHandler.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import SampleAgentHandler.AgentHandler;
import SampleAgentHandler.SampleAgentHandlerPlugin;

/**
 * TODO: Provide description for "DisconnectAction".
 * @see IWorkbenchWindowActionDelegate
 */
public class DisconnectAction implements IWorkbenchWindowActionDelegate 
{
	private IWorkbenchWindow window;
	/**
	 * TODO: Implement the "DisconnectAction" constructor.
	 */
	public DisconnectAction() {
	}

	/**
	 * TODO: Implement "run".
	 * @see IWorkbenchWindowActionDelegate#run
	 */
	public void run(IAction action)  
	{
		AgentHandler agentHandler = SampleAgentHandlerPlugin.getDefault().getAgentHandler();
		
		if ( agentHandler.isConnected() )
		{
			if ( !agentHandler.stopMonitoring() )
			{
				MessageDialog.openInformation(
					window.getShell(),
					"SampleAgentHandler Plug-in",
					"Unable to stop monitoring agent");
				return;
			}

			if ( !agentHandler.disconnect() )
			{
				MessageDialog.openInformation(
					window.getShell(),
					"SampleAgentHandler Plug-in",
					"Unable to disconnect");
				return;
			}
		}
	}

	/**
	 * TODO: Implement "selectionChanged".
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection)  {
	}

	/**
	 * TODO: Implement "dispose".
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose()  {
	}

	/**
	 * TODO: Implement "init".
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window)  
	{
		this.window = window;
	}
}
