/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial implementation
 *    Andy Kaylor, Intel - Modified for sample client to make it a stress test
 *
 * $Id: GetAndRelease.cpp,v 1.4 2005/11/05 01:33:53 koleary Exp $
 *
 *******************************************************************************/ 


#include <iostream>
#include <stdlib.h>
#include <stdio.h>
using namespace std;

#include "tptp/client/INode.h"
#include "tptp/client/NodeFactory.h"
#include "tptp/client/Agent.h"
#include "tptp/client/Collector.h"
#include "tptp/client/Constants.h"
#include "tptp/client/IProcess.h"
#include "tptp/TPTPSupportTypes.h"

#include <time.h>

using namespace TPTP::Client;

/* Test setting default */
int  numIterations = 200;

int processCommandLineOptions( int argc, char* argv[] );


/**
 *********************************************************
 *                                                       
 * @brief                                                
 *    Sample Client
 *
 *********************************************************/
int main(int argc, char* argv[])
{
	int rc = 0 ;
	char* hostName = "localhost";
	int portNum = 10006;
	INode* SampleNode = 0;
	AgentController* ACProxy = 0;
	int i;
	time_t begin, end;
	double elapsed_time;

	rc = processCommandLineOptions( argc, argv );
	if ( rc < 0 )
		return rc;

	//Create a Node that represents the Target Machine
	SampleNode = NodeFactory::createNode(hostName);

	//Connect to the Agent Controller on that machine.
	printf( "Connecting to the Agent Controller on %s...\n\n", hostName );
	ACProxy = SampleNode->connect(portNum);

	if (ACProxy == 0)
	{
		printf( "Unable to connect\n" );
		printf( "Press enter to exit...\n" );
		getchar();
		return -1;
	}

	time( &begin );

	for ( i = 0; i < numIterations; i++ )
	{
		//Get an Agent - StressAgent in this case
		Collector* stressAgent = new Collector("org.eclipse.tptp.StressAgent");
		
		printf( "Getting the Agent...\n" );

		int agentref = ACProxy->getAgent(stressAgent, TPTP_CONTROLLER_ACCESS | TPTP_CREATE_INSTANCE);
		if(agentref == -1)
		{
			printf( "Unable to get Agent org.eclipse.tptp.StressAgent\n" );
			printf( "Press enter to exit...\n" );
			getchar();
			return -1;
		}
		printf( "The Stress Agent ID: %d\n", stressAgent->getAgentID() );
		
		// Release the stress agent 
		printf( "Releasing the Agent...\n" );
		stressAgent->releaseAgent();
		
		delete stressAgent;
	}

	time( &end );

	elapsed_time = difftime( end, begin );
	printf( "Completed %d iterations in %.0f seconds\n", i, elapsed_time );

	if ( ACProxy != NULL )
		ACProxy->destroy();

	NodeFactory::deleteNode(SampleNode);
		
	printf( "All finished\n" );


	printf( "Press enter to exit...\n" );
	getchar();

	return 0;
}


int processCommandLineOptions( int argc, char* argv[] )
{
	int i;

	for ( i = 1; i < argc; i++ )
	{
		if ( argv[i][0] == '-' )
		{
			switch ( argv[i][1] )
			{
				case '?':
					printf( "Usage: GetandRelease [options]\n\n" );
					printf( "   -?       Show this message\n" );
					printf( "   -n<N>    Repeat the test for <N> iterations\n" );
					return -1;
					break;

				case 'n':
					numIterations = atoi( &argv[i][2] );
					if ( numIterations == 0 )
					{
						printf( "Bad value for -n option\n\n" );
						printf( "   -n<N>  Repeat the test for <N> iterations\n" );
						printf( "          Specify a non-zero integer for <N>\n" );
						return -1;
					}
					break;

				default:
					break;
			}
		}
	}

	return 0;
}
