/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation
 *
 * $Id: TestDataProcessor.cpp,v 1.1 2005/10/26 19:22:09 akaylor Exp $
 *
 *******************************************************************************/ 


#include <iostream>
#include <memory.h>

#include "TestDataProcessor.h"



using namespace std;


TestDataProcessor::TestDataProcessor()
{
}


TestDataProcessor::~TestDataProcessor()
{

}

/**
 * Handle the data coming 
 */
void TestDataProcessor::incomingData(char buffer[], int length, DIME_HEADER_PTR_T dimeHeader)
{
	static int totalDataLength = 0;

	totalDataLength += length;

	// We're trying to force a lot of data through.  No time to do more
	if ( totalDataLength > 1000000 )
	{
		printf( "M" );
		totalDataLength = 0;
	}
}


/**
 * Invalid Data Type
 */
void TestDataProcessor::invalidDataType(char data[], int length)
{
	printf( "TestDataProcessor::invalidDataType() called\n" );

}
/**
 * Waiting for data
 */
void TestDataProcessor::waitingForData()
{

	printf( "TestDataProcessor::waitingForData() called\n" );

}


