/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial implementation
 *    Andy Kaylor, Intel - Converted sample to a test agent
 *
 * $Id: StressAgent.h,v 1.1 2005/10/26 19:22:09 akaylor Exp $
 *
 *******************************************************************************/ 

#ifndef  StressAgent_H
#define  StressAgent_H


#include "tptp/agents/BaseCollectorImpl.h"
#include <iostream>

using namespace std;

class StressAgent : public BaseCollectorImpl
{

	private:
		bool running;
		int  dataListenerID; /* This needs to be revisited */

		int sendRunResponse(CmdBlock* cmdBlock);
		int sendStopResponse(CmdBlock* cmdBlock);
		int sendPingResponse(CmdBlock* cmdBlock);

		int receiveData(int sourceID, char buffer[], int bytesRead, DIME_HEADER_PTR_T dimeHeader);

#ifdef _WIN32
		static DWORD WINAPI runThreadWin32(LPVOID param);
#else
		static void *runThreadNonWin32(void* param);
#endif

	public:

		StressAgent(char* agentName);
		~StressAgent();

		virtual int run(CmdBlock* cmdBlock);
		virtual int stop(CmdBlock* cmdBlock);

		virtual int processCommand(CmdBlock* cmdBlock);

		void StressAgent::runThread();
};

#endif

