
################################################################################
#                                       
#  makefile:  client project            
#                                       
# $Id: LaunchAgentClient.make,v 1.2 2009/01/16 14:35:05 jwest Exp $                                  
################################################################################


#-----------------------------------
#
#   Customizable section
#
#-----------------------------------
TARGET         :=  ProcessLaunchTestClient
TARGETDIR      :=  ../../bin


#-----------------------------------
#   list of additional INCLUDE directories to search headers from
#      (separated by blanks)
#-----------------------------------
INCLUDEDIRS    :=  . ../../include


#-----------------------------------
#   list of additional libraries to be linked with
#      (separated by blanks)
#-----------------------------------
LIBS       :=  uuid dl tptpClient xerces-c transportSupport tptpUtils

#-----------------------------------
#   list of additional library directories to search from
#      (separated by blanks)
#-----------------------------------
LIBDIRS    :=  ../../bin ${XERCESC_HOME}/lib


#-----------------------------------
#
#   Compiler options
#
#      -g       produce debug info
#      -Wall    enable all types of warnings
#      -O3      highest level of code optimization
#      -fPIC    generate position-independent code (PIC).
#               This is required for building shared library.
#      -c       compile only
#
#   Linking options
#
#       -Wl       pass options to linker
#       -shared   produce shared library
#       -L        add the given directory to the search path for libraries
#
#-----------------------------------

UNAME = $(shell uname -s)
MNAME = $(shell uname -m)

ifeq ($(UNAME), Linux)
	ifeq ($(MNAME), s390x)
		DEFINES += -D_LINUX_390
	else
		ifeq ($(MNAME), s390)
			DEFINES += -D_LINUX_390
		else
			DEFINES += -D_LINUX_X86
		endif
	endif
endif

CFLAGS     :=  -g -Wall -O3 -fPIC $(addprefix -I,$(INCLUDEDIRS)) $(DEFINES)

CXXFLAGS   :=  $(CFLAGS)

LINKOPTS   :=  -g  -o $(TARGETDIR)/$(TARGET) $(addprefix -L,$(LIBDIRS))


#-----------------------------------
#   general commands and options
#-----------------------------------

CC          :=  g++
CXX         :=  $(CC)

SOURCE     :=  $(wildcard *.cpp)

OBJS       :=  $(patsubst %.cpp,%.o,$(SOURCE))

REMOVEFILE :=  rm -f
CREATELINK :=  ln -sf


#-----------------------------------
#   "make" rules
#-----------------------------------

.PHONY : default everything objs clean veryclean rebuild $(TARGET)


default : $(TARGET)


objs : $(OBJS)


clean :
	$(REMOVEFILE) *.o


veryclean: clean
	$(REMOVEFILE) $(TARGETDIR)/$(TARGET)

rebuild: veryclean everything


$(TARGET) : $(OBJS)
	$(CC) $(LINKOPTS) $(OBJS) $(addprefix -l,$(LIBS))

