/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation
 *
 * $Id: LaunchConsoleAgentClient.cpp,v 1.2 2005/11/05 00:52:23 koleary Exp $
 *
 *******************************************************************************/ 



#include <iostream>
#include <stdlib.h>
#include <stdio.h>
using namespace std;

#include "tptp/client/NodeFactory.h"
#include "tptp/client/Collector.h"
#include "TimeDataProcessor.h"
using namespace TPTP::Client;

/**
 *********************************************************
 *                                                       
 * @brief                                                
 *    Sample Client
 *
 *********************************************************/
int main(int argc, char* argv[])
{
	int rc = 0 ;
	

	//Create a Node that represents the Target Machine
	INode* SampleNode = NodeFactory::createNode("localhost");

	//Connect to the Node
	cout<<endl<<"Connecting to the Node..."<<endl<<endl;
	//Get the Agent Controller Proxy on the Node
	AgentController* ACProxy = SampleNode->connect(10006);

	// Launch the TimeCollector agent from the client, then use
	// getAgent to obtain a reference to it.
	
	IProcess* TimeCollectorProcess = ACProxy->createNewProcess();

	TimeCollectorProcess->setExecutable("C:\\TPTP4.0WindowsGA\\sdk\\bin\\TimeCollector.exe");
	TimeCollectorProcess->setParameter("C:\\TPTP4.0WindowsGA\\sdk\\bin\\TimeCollector.exe");
	TimeCollectorProcess->setLocation(".");	
	TimeCollectorProcess->launch();

	Sleep(100);  //Give the Agent time to startup and register.

	//Get an Agent - TimeCollector Agent in this case
	Collector* timeCollector = new Collector("org.eclipse.tptp.TimeCollector");
	ACProxy->getAgent(timeCollector, TPTP_CONTROLLER_ACCESS);
	cout<<endl<<"The Time Collector Agent ID: "<<timeCollector->getAgentID()<<endl<<endl;
	
	//Establish Data Path and Data Listener
	cout<<"Establish the Data Channel Path with the Time Collector Agent..."<<endl;
	timeCollector->createDataConnection(TPTP_DATA_PATH_TWOWAY);
	TimeDataProcessor* dataProcessor = new TimeDataProcessor();
	int dataConnectionID = timeCollector->addDataListener(dataProcessor);

	char buffer[1024];				
	for(int i=0;i<10;i++)
	{
		sprintf(buffer, "Hello from Sample Client to Time Collector Agent - Count %d !!!", i) ;
		// sent data through the path 
		cout<<"Sending Hello over Data Channel to TimeCollector - Count "<<i<<endl;
		int length = strlen(buffer);
		timeCollector->sendData(buffer, length+1);
		Sleep(1000);
	}
	
	//Send RUN command - Starts the TimeCollector
	cout<<"Start the TimeCollector..."<<endl;
	timeCollector->run();

	cout<<"Wait for few seconds before stopping the TimeCollector..."<<endl;
	Sleep(5000);

	cout<<"Stop the TimeCollector..."<<endl;
	timeCollector->stop();

	cout<<"Wait before releasing the agent..."<<endl;
	Sleep(10000);

	/* Release the time collector */
	timeCollector->releaseAgent();
	
	delete(timeCollector);

	ACProxy->destroy();

	NodeFactory::deleteNode(SampleNode);

	cout<<"All finished"<<endl;

	while(1){Sleep(5000);};

	return 0;
}


