/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CertificateProperties.java,v 1.5 2006/02/06 18:13:08 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.security.internal.util;

import java.security.Key;
import java.security.cert.X509Certificate;

import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.ibm.icu.text.DateFormat;

public class CertificateProperties extends Dialog {

	private String alias;
	private Object cert;
	/**
	 * Constructor for PDCertificateProperties.
	 * @param parentShell
	 */
	public CertificateProperties(Shell parentShell) {
		super(parentShell);
	}
	
	public void init(String alias, Object cert){
		
		this.alias = alias;
		this.cert = cert;	
	}

	protected Control createDialogArea(Composite parent){ 

		getShell().setText(SecurityMessages._17);
		Composite content = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		GridData data = GridUtil.createFill();
		data.widthHint = 450;
		//data.heightHint = 300;
		layout.numColumns = 2;
		content.setLayout(layout);
		content.setLayoutData(data);
		
		Label lblAlias = new Label(content, SWT.NONE);
		lblAlias.setText(SecurityMessages._25);
		data = new GridData();
		data.horizontalIndent = 5;
		lblAlias.setLayoutData(data);
				
		Label lblAliasValue = new Label(content, SWT.NONE);
		lblAliasValue.setText(alias);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalIndent = 5;
		lblAliasValue.setLayoutData(data);
		
		Label lblVersion = new Label(content, SWT.NONE);
		lblVersion.setText(SecurityMessages._18);
		data = new GridData();
		data.horizontalIndent = 5;		
		lblVersion.setLayoutData(data);

		Label lblVersionValue = new Label(content, SWT.NONE);

		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalIndent = 5;		
		lblVersionValue.setLayoutData(data);
				
		Label lblIssuedTo = new Label(content, SWT.NONE);
		lblIssuedTo.setText(SecurityMessages._26);
		data = new GridData();
		data.verticalAlignment = GridData.BEGINNING;
		data.horizontalIndent = 5;		
		lblIssuedTo.setLayoutData(data);
		
		Text lblIssuedToValue = new Text(content, SWT.BORDER | SWT.READ_ONLY | SWT.WRAP) ;
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.heightHint = 60;
		data.horizontalIndent = 5;		
		lblIssuedToValue.setLayoutData(data);

		Label lblIssuedBy = new Label(content, SWT.NONE);
		lblIssuedBy.setText(SecurityMessages._27);
		data = new GridData();
		data.horizontalIndent = 5;
		data.verticalAlignment = GridData.BEGINNING;		
		lblIssuedBy.setLayoutData(data);
		
		Text lblIssuedByValue = new Text(content, SWT.BORDER |SWT.READ_ONLY | SWT.WRAP);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalIndent = 5;
		data.heightHint = 60;				
		lblIssuedByValue.setLayoutData(data);

		Label lblValidity = new Label(content, SWT.NONE);
		lblValidity.setText(SecurityMessages._28);
		data = new GridData();
		data.horizontalIndent = 5;		
		lblValidity.setLayoutData(data);
		
		Label lblValidityValue = new Label(content, SWT.NONE);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalIndent = 5;		
		lblValidityValue.setLayoutData(data);
				
		Label lblAlgorithm = new Label(content, SWT.NONE);
		lblAlgorithm.setText(SecurityMessages._29);
		data = new GridData();
		data.horizontalIndent = 5;		
		lblAlgorithm.setLayoutData(data);

		Label lblAlgorithmValue = new Label(content, SWT.NONE);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalIndent = 5;		
		lblAlgorithmValue.setLayoutData(data);
		
		if(cert instanceof X509Certificate){
			lblVersionValue.setText(((X509Certificate)cert).getType() + " V."+((X509Certificate)cert).getVersion());
			lblIssuedToValue.setText(((X509Certificate)cert).getSubjectDN().getName());
			lblIssuedByValue.setText(((X509Certificate)cert).getIssuerDN().getName());
			DateFormat df = DateFormat.getDateInstance(DateFormat.LONG);
			
			String validity = NLS.bind(SecurityMessages._30, new Object[] { df.format(((X509Certificate)cert).getNotBefore())
					, df.format(((X509Certificate)cert).getNotAfter())});

			lblValidityValue.setText(validity);
			lblAlgorithmValue.setText(((X509Certificate)cert).getSigAlgName());
		}else if(cert instanceof Key){
			lblVersionValue.setText(((Key)cert).getFormat());
			lblAlgorithmValue.setText(((Key)cert).getAlgorithm());
		}
								
		return content;
	}
	
	protected void createButtonsForButtonBar(Composite parent){
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL, true);	
	}
	

}
