/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ImportSecurityCertificate.java,v 1.3 2005/08/13 04:39:52 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.security.internal.util;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportSecurityCertificate
	extends Wizard
	implements IImportWizard {

	private IWorkbench workbench;
	private IStructuredSelection selection;
	private ImportSecurityCertificatePage page;
	/**
	 * Constructor for ImportSecurityCertificate.
	 */
	public ImportSecurityCertificate() {
		super();
	}

	public void addPages()
	{
	  	setWindowTitle(SecurityMessages._3);	
		
		super.addPages();
		page = new ImportSecurityCertificatePage(workbench,selection);
		addPage(page);
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish() {
		
		return page.finish();
	}

	/**
	 * @see org.eclipse.ui.IWorkbenchWizard#init(IWorkbench, IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.workbench = workbench;
		this.selection = selection;
		
	}

}
