/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ImportSecurityCertificatePage.java,v 1.6 2006/09/18 22:12:36 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.security.internal.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.security.KeystoreHelper;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.ui.IWorkbench;

public class ImportSecurityCertificatePage extends WizardPage implements Listener
{
    private SecurityUI _securityUI;
	
	/**
	 * Constructor for ImportSecurityCertificatePage.
	 * @param name
	 * @param selection
	 */
	public ImportSecurityCertificatePage(
		IWorkbench workbench,
		IStructuredSelection selection) {
		super(SecurityMessages._5);
		setTitle(SecurityMessages._5);
		setDescription(SecurityMessages._14);
		setImageDescriptor(
			HyadesUIImages.INSTANCE.getImageDescriptor(HyadesUIImages.IMG_WZ_IMPORT_CERTIF));
		
	}

	/**
	 * 
	 */
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout());
		GridData data = GridUtil.createFill();
		data.widthHint = 300;
		composite.setLayoutData(data);
		composite.setLayoutData(data);
		Shell shell	= getShell();

		_securityUI = new SecurityUI(shell);
		_securityUI.createContents(composite);
        _securityUI.registerListener(this);
		setControl(composite);
		setPageComplete(false);
		
	}
	
	protected boolean determinePageCompletion() {
		boolean complete = _securityUI.validateDialog();

		if (complete)
			setErrorMessage(null);

		return complete;
	}
	
	public boolean finish()
	{	
		String storePath = CommonUIPlugin.getKeyStoreLocation();
		String passw = CommonUIPlugin.getDefault().getWorkspaceName();
		KeyStore ks;
			
		try{	
			ks = getKeyStore();
			_securityUI.loadCertificate(ks);
		}
		catch(FileNotFoundException e){

			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR
					,NLS.bind(SecurityMessages._45, _securityUI.getPath()),e);
			ErrorDialog.openError(Display.getCurrent().getActiveShell(),SecurityMessages._41
					, SecurityMessages._31,err);
			return false;
			
		}
		catch(IOException e){

			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR
					,NLS.bind(SecurityMessages._61, _securityUI.getPath()),e);
			ErrorDialog.openError(Display.getCurrent().getActiveShell(),SecurityMessages._41
					, SecurityMessages._31,err);
			return false;
										
		}
		catch(CertificateException exc){

			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR
					,NLS.bind(SecurityMessages._60, _securityUI.getPath()),exc);
			ErrorDialog.openError(Display.getCurrent().getActiveShell(),SecurityMessages._41
					, SecurityMessages._31,err);
			return false;

		}
		catch(KeyStoreException exc){
			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR
					,NLS.bind(SecurityMessages._49, CommonUIPlugin.getKeyStoreLocation()),exc);
			ErrorDialog.openError(Display.getCurrent().getActiveShell(),SecurityMessages._41
					, SecurityMessages._31,err);
			return false;

		}
		catch(NoSuchProviderException exc2){

			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR
					,NLS.bind(SecurityMessages._58, CommonUIPlugin.getKeyStoreLocation()),exc2);
			ErrorDialog.openError(Display.getCurrent().getActiveShell(),SecurityMessages._41
					, NLS.bind(SecurityMessages._57, CommonUIPlugin.getKeyStoreLocation()),err);
			return false;
		
		}
		catch(NoSuchAlgorithmException exc2)
		{
			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR
					,NLS.bind(SecurityMessages._47, CommonUIPlugin.getKeyStoreLocation()),exc2);
			ErrorDialog.openError(Display.getCurrent().getActiveShell(),SecurityMessages._41
					, SecurityMessages._31,err);
			return false;
		}
			


		try{
			
			KeystoreHelper.persistKeyStore(ks, storePath, passw);			
		}
		catch(IOException e){

			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR
					,NLS.bind(SecurityMessages._54, storePath),e);
			ErrorDialog.openError(Display.getCurrent().getActiveShell(),SecurityMessages._41
					, SecurityMessages._53,err);
			return false;
										
		}
		catch(CertificateException exc){

			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR
					,NLS.bind(SecurityMessages._55, storePath),exc);
			ErrorDialog.openError(Display.getCurrent().getActiveShell(),SecurityMessages._41
					, SecurityMessages._53,err);
			return false;

		}
		catch(KeyStoreException exc){

			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR
					,NLS.bind(SecurityMessages._56, CommonUIPlugin.getKeyStoreLocation()),exc);
			ErrorDialog.openError(Display.getCurrent().getActiveShell(),SecurityMessages._41
					, SecurityMessages._53,err);
			return false;

		}
		catch(NoSuchAlgorithmException exc2)
		{
			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR
					,NLS.bind(SecurityMessages._47, CommonUIPlugin.getKeyStoreLocation()),exc2);
			ErrorDialog.openError(Display.getCurrent().getActiveShell(),SecurityMessages._41
					, SecurityMessages._53,err);
			return false;
		}
		

		return true;
	}

	public void handleEvent(Event e){
		setPageComplete(determinePageCompletion());
	}

    private KeyStore getKeyStore() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException{
		return KeystoreHelper.createKeyStore(CommonUIPlugin.getKeyStoreLocation(), CommonUIPlugin.getDefault().getWorkspaceName());    	
    }
		
}
