/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: UntrustedAgentControllerDialog.java,v 1.3 2005/08/13 04:39:52 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.security.internal.util;

import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class UntrustedAgentControllerDialog extends Dialog {

//    private ConnectivityUI _connectivityUI;
    private String fDescription;
	
	public UntrustedAgentControllerDialog(Shell shell){
		this(shell, "", "", true);
	}
	
	public UntrustedAgentControllerDialog(Shell shell, String userId){
		this(shell, userId, "", true);
	}
	
	public UntrustedAgentControllerDialog(Shell shell, String userId, boolean selectUserField){
		this(shell, userId, "", selectUserField);
	}	

	public UntrustedAgentControllerDialog(Shell shell, String userId, String password, boolean selectUserField){
		super(shell);
	}
	
	protected Control createDialogArea(Composite parent){ 

		getShell().setText(SecurityMessages._41);
		Composite content = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		GridData data = GridUtil.createFill();
		layout.numColumns = 1;
		content.setLayout(layout);
		content.setLayoutData(data);
		

		Label label = new Label(content, SWT.NONE);
		data = new GridData();
		data.horizontalSpan = 2;
		label.setLayoutData(data);
		String text = fDescription+"\n";
		label.setText(text);				
		return content;
	}
	
	protected Control createButtonBar(Composite parent) {
		Control control = super.createButtonBar(parent);
		getShell().setDefaultButton(getButton(IDialogConstants.OK_ID));
		return control;
		
	}
	

    public void setDescription(String desc)
    {
    	fDescription = desc;
    }	
}
