/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HyadesUIImages.java,v 1.9 2009/03/24 16:12:35 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui;

import java.net.URL;

import org.eclipse.hyades.ui.internal.util.ImageManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIImages;

/**
 * <p>Hyades UI image manager.</p>
 * 
 * <p><b>Note:</b>This class is not intended to be extended 
 * or used externally, and images are subject to be changed 
 * without notice.</p>
 * 
 * 
 * @author  Marcelo Patmarcelop
 * @author  Valentia Popescu
 * @author  Paul Slauenwhite
 * @version March 24, 2009
 * @since   January 26, 2005
 */
public class HyadesUIImages extends ImageManager
{
	/**
	 * HyadesUIImages' singleton.
	 */
	public static final HyadesUIImages INSTANCE = new HyadesUIImages();
	
	/**
	 * No-argument constructor.
	 */
	public HyadesUIImages(){
		
		try	{
			initialize(new URL(HyadesUIPlugin.getInstance().getBundle().getEntry("/"), "icons/full/"), HyadesUIPlugin.getInstance().getImageRegistry()); //$NON-NLS-1$ //$NON-NLS-2$
		}
		catch(Exception e) {
			CommonPlugin.logError(e);
		}	
	}
	
	/*
	 * Available cached Images in the Java plugin image registry.
	 */
	public static final String IMG_CERTIF_FILE 	= "certif_file.gif";	
	public static final String IMG_FILTER_LOG_AGENT 	= "agent_log_obj.gif";
	public static final String IMG_FILTER_PROF_AGENT 	= "agent_prof_obj.gif";
	public static final String IMG_UI_MONITOR    		= "monitor_obj.gif";
	public static final String IMG_UI_NODE       		= "node_obj.gif";
	public static final String IMG_UI_PROCESS    		= "process_obj.gif";
	public static final String IMG_UI_VIEW_FILTER  		= "view_filter.gif";		
	public static final String IMG_WZ_IMPORT_CERTIF 	= "import_cert_wiz.gif";
	public static final String IMG_WZ_IMPORT_FILTER    	= "filter_import_wiz.gif";
	public static final String IMG_WZ_EXPORT_FILTER    	= "filter_export_wiz.gif";
	public static final String IMG_WZ_FILTER    		= "filter_wiz.gif";		
	public static final String IMG_EXPORT 				= CommonUIImages.IMG_UI_REPORT;
	
	public static final String IMG_ZOOMSLIDER_LOCK 		= "zoomslider_lock.gif";
	
	/**
	 * @see org.eclipse.hyades.ui.util.ImageManager#addImages()
	 */
	protected void addImages()
	{
		add(T_OBJ,IMG_CERTIF_FILE);			
		add(T_OBJ,IMG_FILTER_PROF_AGENT);
		add(T_OBJ,IMG_FILTER_LOG_AGENT);
		add(T_OBJ,IMG_UI_MONITOR);
		add(T_OBJ,IMG_UI_NODE);   
		add(T_OBJ,IMG_UI_PROCESS);
		add(T_WIZBAN,IMG_WZ_IMPORT_CERTIF);
		add(T_WIZBAN,IMG_WZ_IMPORT_FILTER);	
		add(T_WIZBAN,IMG_WZ_EXPORT_FILTER);
		add(T_WIZBAN,IMG_WZ_FILTER);			
        add("c", T_LCL, IMG_UI_VIEW_FILTER);
        add("d", T_LCL, IMG_UI_VIEW_FILTER);
        add("e", T_LCL, IMG_UI_VIEW_FILTER);     
        
		add("zoomslider", IMG_ZOOMSLIDER_LOCK);
	}	
	
	public Image getImage(String key)
	{
		Image img = CommonUIImages.INSTANCE.getImage(key);
		if (img != null)
			return img;
		return super.getImage(key);
	}
	
	
	public ImageDescriptor getImageDescriptor(String key)
	{
		ImageDescriptor imgDesc = CommonUIImages.INSTANCE.getImageDescriptor(key);
		if (imgDesc != null)
			return imgDesc;
		return super.getImageDescriptor(key);
	}
}
