/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id$
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.editor;

import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.StatusLineContributionItem;

/** 
 * Basic Hyades editor contributor.
 * This class is in charge to add specific contributions.
 * @author jgout
 * @since 3.3
 */
public class HyadesEditorActionContributor extends EditorActionBarContributor {

	
	private StatusLineContributionItem writableContributionItem;

	public void contributeToStatusLine(IStatusLineManager statusLineManager) {
		super.contributeToStatusLine(statusLineManager);
		writableContributionItem = new StatusLineContributionItem(ITextEditorActionConstants.STATUS_CATEGORY_ELEMENT_STATE, true, 15);
		statusLineManager.add(writableContributionItem);
	}
	
	public void setWritable(boolean writable) {
		String msg = writable ? UIMessages.STATUS_LINE_WRITABLE : UIMessages.STATUS_LINE_READONLY; //$NON-NLS-1$ //$NON-NLS-2$
		writableContributionItem.setText(msg);
	}
}
