/********************************************************************** 
 * Copyright (c) 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id$ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.ui.editor;

import org.eclipse.ui.IWorkbenchPart;

/**
 * This interface is intended to clients that need to override default Edit menu actions.
 * @author jgout
 * @since 4.2
 */
public interface IEditActionsExtension {
    
    /**
     * Implementors use this method in order to connect thier own set of actions in the given part.
     * Implementors need to ensure that the following actions are properly created, initialized and registered:
     * <ul>
     * <li>Revert</li>
     * <li>Cut</li>
     * <li>Copy</li>
     * <li>Paste</li>
     * <li>Select All</li>
     * <li>Delete</li>
     * </ul>
     * @param part the part within the actions should be added.
     */
    public void connectPart(IWorkbenchPart part);


}
