/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AssociationDescriptorLabelProvider.java,v 1.2 2005/02/25 22:17:20 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.extension;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import org.eclipse.hyades.ui.util.ILabelAndDescriptionProvider;

/**
/**
 * Implementation of a {@link org.eclipse.hyades.ui.util.ILabelAndDescriptionProvider}
 * for a {@link org.eclipse.hyades.ui.extension.IAssociationDescriptor}.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class AssociationDescriptorLabelProvider
extends LabelProvider implements ILabelAndDescriptionProvider
{
	/**
	 * @see org.eclipse.hyades.ui.util.ILabelAndDescriptionProvider#getDescription(java.lang.Object)
	 */
	public String getDescription(Object element)
	{
		if(element instanceof IAssociationDescriptor)
			return ((IAssociationDescriptor)element).getDescription();
		return null;
	}
	
	/**
	 * @see org.eclipse.jface.viewers.ILabelProvider#getImage(java.lang.Object)
	 */
	public Image getImage(Object element)
	{
		if(element instanceof IAssociationDescriptor)
			return ((IAssociationDescriptor)element).getImage();
		return super.getImage(element);
	}

	/**
	 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object element)
	{
		if(element instanceof IAssociationDescriptor)
			return ((IAssociationDescriptor)element).getName();
		return super.getText(element);
	}
}
