/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITypeValidator.java,v 1.2 2005/02/25 22:17:20 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.extension;

/**
 * Interface for a type validator contributed using typeValidators extension point
 * A type validator returns whether a type is valid in the context the validator
 * is registered for.
 * 
 * @author popescu
 * @author marcelop
 * @since 0.2.0 
 */
public interface ITypeValidator
{
	/**
	 * Returns wether the type is valid within the context this validator
	 * is registered.
	 * @param type
	 * @return boolean
	 */
	public boolean isValidType(String type);
}
