/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PageContainerEditorPart.java,v 1.8 2010/02/08 13:38:54 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.editor;

import org.eclipse.hyades.ui.editor.IHyadesEditorPartExtended;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.editor.FormEditor;

/**
 * Abstract multi-page editor part.  This editor is used to make public the
 * protected methods defined in MultiPageEditorPart that are present in the
 * IHyadesEditorPart interface.
 * 
 * @author marcelop
 * @author Jerome Bozier
 * @since 0.0.1
 * @version February 8, 2010
 */
public abstract class PageContainerEditorPart 
extends FormEditor implements IHyadesEditorPartExtended, IDisposable
{
	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#getActivePage()
	 */
	public int getActivePage()
	{
		return super.getActivePage();
	}

	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#getPageImage(int)
	 */
	public Image getPageImage(int pageIndex)
	{
		return super.getPageImage(pageIndex);
	}

	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#getPageText(int)
	 */
	public String getPageText(int pageIndex)
	{
		return super.getPageText(pageIndex);
	}

	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#setActivePage(int)
	 */
	public void setActivePage(int pageIndex)
	{
		super.setActivePage(pageIndex);
	}

	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#setControl(int, org.eclipse.swt.widgets.Control)
	 */
	public void setControl(int pageIndex, Control control)
	{
		super.setControl(pageIndex, control);
	}

	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#setPageImage(int, org.eclipse.swt.graphics.Image)
	 */
	public void setPageImage(int pageIndex, Image image)
	{
		super.setPageImage(pageIndex, image);
	}

	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#setPageText(int, java.lang.String)
	 */
	public void setPageText(int pageIndex, String text)
	{
		super.setPageText(pageIndex, text);
	}
	
	/**
	 * @see IPageContainer#getContainerComposite()
	 * @see org.eclipse.ui.part.MultiPageEditorPart#getContainer()
	 */
	public Composite getContainerComposite()
	{
		return super.getContainer();
	}
	
	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#getControl(int)
	 */
	public Control getControl(int pageIndex)
	{
		return super.getControl(pageIndex);
	}
	
	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#getEditor(int)
	 */
	public IEditorPart getEditor(int pageIndex)
	{
		if (pages.size() == 0) {
			return null; // no pages => no editor
		}
		return super.getEditor(pageIndex);
	}

	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#getPageCount()
	 */
	public int getPageCount()
	{
		return super.getPageCount();
	}
	
	/**
	 * @deprecated use #setEditorTitle(String) instead.
	 */
	public void setTitle(String title)
	{
		// WorkbenchPart.setTitle(String) is deprecated and replaced by setPartName(String).
		// the implementation of setPartName(title) in WorkbenchPart calls its setTitle which is overridden here, 
		// thus will cause stack overflow error if calls super.setPartName(title) here. 
		// WorkbenchPart.setTitle() and setPartName() should not be overridden.
		// This method is kept here only to be API backward compatible.
		// setPartName(title);
		super.setTitle(title);
		//setContentDescription(title);
	}
	
	public void setEditorTitle(String title)
	{
		setPartName(title);
	}

	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#setTitleImage(org.eclipse.swt.graphics.Image)
	 */
	public void setTitleImage(Image titleImage)
	{
		super.setTitleImage(titleImage);
	}

	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#setTitleToolTip(java.lang.String)
	 */
	public void setTitleToolTip(String text)
	{
		super.setTitleToolTip(text);
	}
	
	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#firePropertyChange(int)
	 */
	public void firePropertyChange(int propertyId)
	{
		super.firePropertyChange(propertyId);
	}
	
	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#getContainer()
	 */
	public Composite getContainer()
	{
		return super.getContainer();
	}
}
