/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NavigatorSorterAction.java,v 1.5 2006/10/30 18:08:50 amehregani Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.navigator.action;

import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.NavigatorViewerSorter;
import org.eclipse.jface.viewers.ViewerSorter;

/**
 * Action to set the criteria of a 
 * {@link org.eclipse.hyades.ui.internal.navigator.NavigatorViewerSorter}.  Each instance
 * of this class is associated to a specific criteria.
 * 
 * @author marcelop
 * @since 0.0.1 
 */
public class NavigatorSorterAction 
extends NavigatorAction
{
	private int criteria;
	
	/**
	 * Constructor for NavigatorSorterAction
	 * @param navigator
	 * @param label
	 */
	public NavigatorSorterAction(INavigator navigator, String label, int criteria)
	{
		super(navigator,label);
		this.criteria = criteria;					
	}
	
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		ViewerSorter sorter = getNavigator().getViewer().getSorter();
		if(sorter instanceof NavigatorViewerSorter)
			((NavigatorViewerSorter)sorter).setCriteria(criteria);
	}
}
