/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NewObjectAction.java,v 1.8 2010/02/23 13:33:36 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.navigator.action;

import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewWizardAction;

/**
 * <p>Action to display the new wizard for a specific category.</p> 
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Paul Slauenwhite
 * @version February 23, 2010
 * @since   January 26, 2005
 */
public class NewObjectAction extends NewWizardAction implements IDisposable {
	
	/**
	 * The dialog settings from which the last usage is retrieved.
	 */
	private IDialogSettings settings = null;
	
	/**
	 * The wizard title.
	 */
	private String wizardTitle = null;

	/**
	 * Constructor for NewHyadesObjectAction
	 * @param wizardCategory
	 */
	public NewObjectAction()
	{
		this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());										
	}

	/**
	 * Constructor for NewObjectAction.  Creates a new action for 
	 * launching the new project selection wizard.
	 *
	 * @param window the workbench window to query the current
	 * @param wizardCategory
	 * selection and shell for opening the wizard.
	 */
	public NewObjectAction(IWorkbenchWindow window)
	{
		super(window);
	}
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		settings = null;
		
		super.dispose();
	}

	/**
	 * Sets the dialog settings from where the last usage settings are retrieved.  The
	 * settings defined are considered as the settings section reserved for the 
	 * wizard created by this action. 
	 * @param dialogSettings
	 */
	public void setSettings(IDialogSettings settings)
	{
		this.settings = settings;
	}
	
	/**
	 * Returns the dialog settings.
	 * @return IDialogSettings
	 */
	public IDialogSettings getSettings()
	{
		return settings;
	}
	
	/**
	 * Sets the category of the wizards that are presented by this action 
	 * @param wizardCategory
	 */
	public void setWizardCategory(String wizardCategory)
	{
		setCategoryId(wizardCategory);
	}

	/**
	 * Returns the category of the wizards that are presented by this action 
	 * @return String
	 */
	public String getWizardCategory()
	{
		return (getCategoryId());
	}

	/**
	 * <p>Sets the title of the wizard window.<p>
	 * 
	 * <p>If the title of the wizard window is <code>null</code>, the default
	 * wizard window title will be used.</p>
	 * 
	 * @param wizardTitle The title of the wizard window, otherwise <code>null</code> (default wizard window title).
	 */
	public void setWizardTitle(String wizardTitle){
		
		this.wizardTitle = wizardTitle;
		
		setWizardWindowTitle(wizardTitle);
	}

	/**
	 * <p>Gets the title of the wizard window.<p>
	 * 
	 * <p>If the title of the wizard window is <code>null</code>, the default
	 * wizard window title will be used.</p>
	 * 
	 * @return The title of the wizard window, otherwise <code>null</code> (default wizard window title).
	 */
	public String getWizardTitle(){
		return wizardTitle;
	}
}
