/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RuntimeExceptionDecorator.java,v 1.5 2005/05/25 18:39:09 ewchan Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.util;

import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * Decorates a throwable given a RuntimeException behavior to it.  It can
 * be used to throw any throwable without adding any catch mechanism.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class RuntimeExceptionDecorator
extends RuntimeException
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 3257001068670891065L;
	private Throwable throwable;
	 
	/**
	 * Contructor for RuntimeExceptionDecorator
	 * @param throwable The throwable to be decorated. 
	 */
	public RuntimeExceptionDecorator(Throwable throwable)
	{
		this.throwable = throwable;
	}
			
	/**
	 * @see java.lang.Throwable#fillInStackTrace()
	 */
	public Throwable fillInStackTrace()
	{
		if(throwable == null)
			return super.fillInStackTrace();
			
		return throwable.fillInStackTrace();
	}

	/**
	 * @see java.lang.Throwable#getLocalizedMessage()
	 */
	public String getLocalizedMessage()
	{
		return throwable.getLocalizedMessage();
	}

	/**
	 * @see java.lang.Throwable#getMessage()
	 */
	public String getMessage()
	{
		return throwable.getMessage();
	}

	/**
	 * @see java.lang.Throwable#printStackTrace()
	 */
	public void printStackTrace()
	{
		throwable.printStackTrace();
	}

	/**
	 * @see java.lang.Throwable#printStackTrace(java.io.PrintStream)
	 */
	public void printStackTrace(PrintStream s)
	{
		throwable.printStackTrace(s);
	}

	/**
	 * @see java.lang.Throwable#printStackTrace(java.io.PrintWriter)
	 */
	public void printStackTrace(PrintWriter s)
	{
		throwable.printStackTrace(s);
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		return throwable.toString();
	}
}