/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: UIUtil.java,v 1.12 2008/04/16 15:16:18 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;

/**
 * Contains UI utility methods.
 * <p/>
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Valentina Popescu
 * @author  Paul E. Slauenwhite
 * @version April 16, 2008
 * @since   January 26, 2005
 */
public class UIUtil extends org.eclipse.tptp.platform.common.ui.internal.util.UIUtil 
{	
	/**
	 * Fires the current selection of a given structured viewer.
	 * @param structuredViewer
	 * @return <code>true</code> if the selection was fired or <code>false</code>
	 * otherwise. 
	 */
	public static boolean fireCurrentSelection(StructuredViewer structuredViewer)
	{
		SelectionChangedEvent event = new SelectionChangedEvent(structuredViewer, structuredViewer.getSelection());
		try
		{
			CoreUtil.invokeObjectMethod(structuredViewer, "fireSelectionChanged", new Object[]{event}, true);
		}
		catch(RuntimeException e)
		{
			CommonPlugin.logError(e);
			return false;
		}
		
		return true;
	}
	

	
	/**
	 * Returns the opened editor associated with a given IFile.
	 * @param inputFile
	 * @return IEditorPart
	 */
	public static IEditorPart getOpenEditor(IFile inputFile)
	{
		IWorkbenchPage activePage = getActiveWorkbenchPage();
		if(activePage == null)
			return null;
			
		IEditorReference[] editorReferences = activePage.getEditorReferences();
		for(int i=0, length=editorReferences.length; i<length; i++)
		{
			IEditorPart editorPart = editorReferences[i].getEditor(false);
			if(editorPart == null)
				continue;
				
			Object input = editorPart.getEditorInput();
			if((input != null) && (input instanceof IFileEditorInput))
			{
				IFile file = ((IFileEditorInput)input).getFile();
				if((file != null) && (inputFile != null) && (file.equals(inputFile)))
					return editorPart;
				
				if((file == null) && (inputFile == null))
					return editorPart;
			}
		}

		return null;
	}
	

	
	
	/**
	 * Applies all the filters of the specified structured viewer to the element
	 * array.
	 * @param structuredViewer
	 * @param elements
	 * @return Object[]
	 */
	public static Object[] applyFilters(StructuredViewer structuredViewer, Object parent, Object[] elements)
	{
		if(elements.length == 0)
			return elements;
			
		ViewerFilter[] filters = structuredViewer.getFilters();
		for(int i = 0, maxi = filters.length; i < maxi; i++)
		{
			elements = filters[i].filter(structuredViewer, parent, elements);
			if(elements.length == 0)
				return elements;
		}
		return elements;
	}
	

	public static void integerStyledTextVerifyKey(VerifyEvent event)
	{
		if(event.doit)
		{
			switch(event.keyCode)
			{
				case SWT.ARROW_DOWN:			
				case SWT.ARROW_UP:
				case SWT.ARROW_LEFT:
				case SWT.ARROW_RIGHT:
				case SWT.HOME:
				case SWT.END:
					return;
			}
			
			switch(event.character)
			{
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
				case SWT.BS:
				case SWT.DEL:
					return;

				default:
					event.doit = false;
					return;
			}
		}		
	}



	
	/**
	 * This method validates the file name does not contain any invalid
	 * characters determined by Java Naming Conventions.
	 * @param fileName The name of the file 
	 * @return The invalid character or null
	 */
	public static String validateJavaFileName(String valueStr) {
		if (Character.isDigit(valueStr.charAt(0))) {
			return new Character(valueStr.charAt(0)).toString();
		}

		for (int i = 0; i < valueStr.length(); i++) {
			char ch = valueStr.charAt(i);
			switch (ch) {
				case '!':
					return new Character(ch).toString();
				case '@':
					return new Character(ch).toString();
				case '#':
					return new Character(ch).toString();
				case '^':
					return new Character(ch).toString();
				case '\'':
					return new Character(ch).toString();
				case '`':
					return new Character(ch).toString();
				case '<':
					return new Character(ch).toString();
				case '>':
					return new Character(ch).toString();
				case '-':
					if (i != 0) { 
						return new Character(ch).toString();
					}
				case '+':
					return new Character(ch).toString();
				case ' ':
					return "<space>";
				case '|':
					return new Character(ch).toString();
				case '*':
					return new Character(ch).toString();
				case '{':
					return new Character(ch).toString();
				case '}':
					return new Character(ch).toString();
				case '[':
					return new Character(ch).toString();
				case ']':
					return new Character(ch).toString();
				case '(':
					return new Character(ch).toString();
				case ')':
					return new Character(ch).toString();
				case ':':
					return new Character(ch).toString();
				case ';':
					return new Character(ch).toString();
				case ',':
					return new Character(ch).toString();
				case '"':
					return new Character(ch).toString();
				case '/':
					return new Character(ch).toString();
				case '\\':
					return new Character(ch).toString();
				case '~':
					return new Character(ch).toString();
				case '=':
					return new Character(ch).toString();
				case '?':
					return new Character(ch).toString();
				default:
					;
			}
		}
		return null;
	}
	
    /**
     * Resolves the first open {@link IProject} in the workspace.
     * <p/>
     * In no projects exist in the workspace or all projects in
     * the workspace are closed, <code>null</code> is returned.
     * <p/>
     * 
     * @return The first open {@link IProject} in the workspace, otherwise <code>null</code>.
     */
    public static IProject getFirstOpenProject(){
    	
    	IProject[] workspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
    	
    	for (int counter = 0; counter < workspaceProjects.length; counter++) {
			
    		if(workspaceProjects[counter].isOpen()){
    			return (workspaceProjects[counter]);
    		}
		}
    	
    	return null;
    }
}