/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AttributeWizardPage.java,v 1.10 2009/04/02 17:29:03 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.wizard;

import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.ContextIDs;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.ui.PlatformUI;

/**
 * <p>Wizard page that allows the user to define the description of the object 
 * to be created.</p>
 * 
 * 
 * @author      Patrick Nedelec
 * @author      Marcelo Paternostro
 * @author 	    Paul E. Slauenwhite
 * @version     April 2, 2009
 * @since       January 26, 2005
 */
public class AttributeWizardPage extends WizardPage {
    
	protected Text itemDescriptionText;
	protected String itemDescription;

    private boolean firstActivation = true;

    /**
     * Constructor for NameDescriptionWizardPage
     * @param pageName
     */
    public AttributeWizardPage(String pageName) {
        super(pageName);
        setPageComplete(true);
    }

    /**
     * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
     */
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(GridDataUtil.createFill());

        PlatformUI.getWorkbench().getHelpSystem().setHelp(composite, HyadesUIPlugin.getID() + ContextIDs.ATT_WIZ);
        
        Label label = new Label(composite, SWT.NONE);
        label.setText(CommonUIMessages._1); 
        itemDescriptionText = new Text(composite, SWT.BORDER | SWT.MULTI | SWT.V_SCROLL | SWT.WRAP);
        itemDescriptionText.setLayoutData(GridDataUtil.createFill());
        if (itemDescription != null) itemDescriptionText.setText(itemDescription);

        setControl(composite);

    }

    /**
     * @see org.eclipse.jface.dialogs.IDialogPage#setVisible(boolean)
     */
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && firstActivation) {
            itemDescriptionText.setFocus();
            firstActivation = false;
            setPageComplete(validatePage());
            setErrorMessage(null);
        }
    }

    /**
     * Returns whether this page's controls currently all contain valid 
     * values.
     * @return <code>true</code> if all controls are valid, and
     * <code>false</code> if at least one is invalid
     */
    final protected boolean validatePage() {
        return true;
    }

    /**
     * Sets the description to be presented by this wizard page.  If the description's 
     * text wizard is not created then the argument is stored in a class variable.
     * @param description
     */
    public void setItemDescription(String description) {
        if ((itemDescriptionText == null) || itemDescriptionText.isDisposed())
            this.itemDescription = description;
        else
            itemDescriptionText.setText(description);
    }

    /**
     * Returns the description entered by the user or set by the 
     * <code>setDescription</code> method.
     * @return
     */
    public String getItemDescription() {
        if ((itemDescriptionText == null) || itemDescriptionText.isDisposed()) {
            return itemDescription;
        }
        return itemDescriptionText.getText();
    }

    /**
     * @return Returns the firstActivation.
     */
    protected boolean isFirstActivation() {
        return firstActivation;
    }
}