/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id:
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.ui.internal.wizard;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.filters.internal.util.FilterResourceFileHandler;
import org.eclipse.hyades.ui.filters.internal.util.FilterResourceHandler;
import org.eclipse.hyades.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ExportFilterWizardPage extends  ExportImportFilterWizardPage {
    //~ Constructors -------------------------------------------------------------------------------
    /**
     *  Creates an instance of this class
     * @param aWorkbench IWorkbench
     * @param selection IStructuredSelection
     */
    public ExportFilterWizardPage(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("FilterExportPage", aWorkbench, selection); //$NON-NLS-1$
        setTitle(UIMessages._127); 
        setDescription(UIMessages._128); 
        setImageDescriptor(HyadesUIImages.INSTANCE.getImageDescriptor(HyadesUIImages.IMG_WZ_EXPORT_FILTER));
    }

    //~ Methods ------------------------------------------------------------------------------------

    /** (non-Javadoc)
     * Method declared on IDialogPage.
     */
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, SWT.NULL);

        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_FILL | GridData.HORIZONTAL_ALIGN_FILL));
        composite.setSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));

        createBoldLabel(composite, UIMessages._129); 
		
        createDoubleList(composite, UIMessages._130,UIMessages._131); 
		
		createSourceGroup(composite);
        createSpacer(composite);

		initializeValues();
		
        setControl(composite);
        
		PlatformUI.getWorkbench().getHelpSystem().setHelp(
				composite,
				HyadesUIPlugin.getID() + ContextIds.PROFILING_FILTERS_EXPORT);
    }

	protected List populateFilterList() {
		final String NO_FILTER_NAME = CommonUIMessages._111;
		FilterResourceHandler resource = FilterResourceHandler.instance();
		Object[] filterQueries = resource.toArray();
		List list = new ArrayList();
		for (int i = 0; i < filterQueries.length; i++)
		{
			if(!((FilterQueries)filterQueries[i]).name().equals(NO_FILTER_NAME))
				list.add(filterQueries[i]);
		}
		
		return list;
	}
    /**
     * The Finish button was pressed.  Try to do the required work now and answer
     * a boolean indicating success.  If <code>false</code> is returned then the
     * wizard will not close.
     *
     * @return boolean
     */
    public boolean finish() {
    	List filtersToExport = getDoubleList().getTargetItems();
    	
    	String exportFile = sourceNameField.getText().trim();
    	if (!exportFile.endsWith(".filtxml"))
    		exportFile = exportFile + ".filtxml";

    	FilterResourceFileHandler exportResourceHandler = FilterResourceFileHandler.instance(URI.createFileURI(exportFile));

    	exportResourceHandler.clear();
    	for (int i = 0; i < filtersToExport.size(); i++)
    	{
    		exportResourceHandler.addFilter(((FilterQueries)filtersToExport.get(i)).copy());
    	}
    	
    	exportResourceHandler.save();
    	exportResourceHandler.unload();    	

    	return true;
    }


	protected boolean validateLists() {
		return true;
	}
}
