/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: 
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.internal.wizard;

import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;


public class ImportFilterWizard extends Wizard implements IImportWizard
{
	private IWorkbench workbench;
	private IStructuredSelection selection;
	private ImportFilterWizardPage mainPage;

public ImportFilterWizard() {
	AbstractUIPlugin plugin = HyadesUIPlugin.getInstance();
	IDialogSettings workbenchSettings = plugin.getDialogSettings();
	IDialogSettings section = workbenchSettings.getSection("FilterFileImportWizard");//$NON-NLS-1$
	if(section == null)
		section = workbenchSettings.addNewSection("FilterFileImportWizard");//$NON-NLS-1$
	setDialogSettings(section);
}

public void addPages()
{
  	setWindowTitle(UIMessages._119);	
  		
	super.addPages();
	mainPage = new ImportFilterWizardPage(workbench,selection);
	addPage(mainPage);
}

public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
	this.workbench = workbench;
	selection = currentSelection;
	setDefaultPageImageDescriptor(HyadesUIImages.INSTANCE.getImageDescriptor(HyadesUIImages.IMG_WZ_IMPORT_FILTER));
	setNeedsProgressMonitor(true);
}

public boolean performFinish()
{
	return mainPage.finish();
}
}
