/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id:
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.ui.internal.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.filters.internal.util.FilterResourceFileHandler;
import org.eclipse.hyades.ui.filters.internal.util.FilterResourceHandler;
import org.eclipse.hyades.ui.internal.filters.FilterTypesManager;
import org.eclipse.hyades.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ImportFilterWizardPage extends ExportImportFilterWizardPage
{
    //~ Constructors -------------------------------------------------------------------------------

    /**
     *  Creates an instance of this class
     * @param aWorkbench IWorkbench
     * @param selection IStructuredSelection
     */
    public ImportFilterWizardPage(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("FilterImportPage", aWorkbench, selection); //$NON-NLS-1$
        setTitle(UIMessages._120); 
        setDescription(UIMessages._121); 
        setImageDescriptor(HyadesUIImages.INSTANCE.getImageDescriptor(HyadesUIImages.IMG_WZ_IMPORT_FILTER));
    }

    //~ Methods ------------------------------------------------------------------------------------

    /** (non-Javadoc)
     * Method declared on IDialogPage.
     */
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, SWT.NULL);

        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_FILL | GridData.HORIZONTAL_ALIGN_FILL));
        composite.setSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));

        createSourceGroup(composite);

        createSpacer(composite);
        
        createBoldLabel(composite, UIMessages._122); 
		
        createDoubleList(composite, UIMessages._123,UIMessages._124); 
        
        setControl(composite);
        
		PlatformUI.getWorkbench().getHelpSystem().setHelp(
				composite,
				HyadesUIPlugin.getID() + ContextIds.PROFILING_FILTERS_IMPORT);
        
    }
	
	protected List populateFilterList() {
		String filterFile = sourceNameField.getText().trim();
		List list = new ArrayList();

		if ((new File(filterFile)).exists())
		{
	    	FilterResourceFileHandler resource = FilterResourceFileHandler.instance(URI.createFileURI(filterFile));
	    	
			Object[] filterQueries = resource.toArray();
			
			for (int i = 0; i < filterQueries.length; i++)
			{
				if (FilterTypesManager.instance().getFilterType(((FilterQueries)filterQueries[i]).type()) != null)
					list.add(((FilterQueries)filterQueries[i]).copy());
			}
			
			resource.unload();
		}
		return list;    	
	}
	
    /**
     * The Finish button was pressed.  Try to do the required work now and answer
     * a boolean indicating success.  If <code>false</code> is returned then the
     * wizard will not close.
     *
     * @return boolean
     */
    public boolean finish() {
    	List filtersToImport = getDoubleList().getTargetItems();
    	
    	FilterResourceHandler importResourceHandler = FilterResourceHandler.instance();
    	
    	for (int i = 0; i < filtersToImport.size(); i++)
    	{
    		importResourceHandler.addFilter(((FilterQueries)filtersToImport.get(i)).copy());
    	}
    	
    	importResourceHandler.save();

    	return true;
    }

	protected boolean validateLists() {
    	List filtersToImport = getDoubleList().getTargetItems();
    	
    	for (int i = 0; i < filtersToImport.size(); i++)
    	{
    		FilterQueries fq = (FilterQueries)filtersToImport.get(i);
    		if (FilterResourceHandler.instance().filter(fq.name()) != null)
    		{
    			setErrorMessage(NLS.bind(UIMessages._132, fq.name()));
    			return false;
    		}
    	}
        
        return true;
	}
	
    /**
     * Sent when the text is modified.
     *
     * @param e an event containing information about the modify
     */
    public void modifyText(ModifyEvent e) {
    	super.modifyText(e);
        initializeValues();
    }
}
