/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SelectionWizard.java,v 1.3 2005/03/17 11:19:43 dguilbaud Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.wizard.selection;

import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;

/**
 * @author marcelop
 * @since 
 */
public class SelectionWizard extends HyadesWizard
{
	private IWizardElement[] wizardElements;
	private String message;

	private SelectionPage selectionPage;
	
	/**
	 * Constructor for SelectionWizard
	 */
	public SelectionWizard(IWizardElement[] wizardElements, String message)
	{
		super();

		this.wizardElements = wizardElements;
		this.message = message;
		setForcePreviousAndNextButtons(true);
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#dispose()
	 */
	public void dispose()
	{
		wizardElements = null;
		selectionPage = null;
		super.dispose();
	}
	
	/**
	 * Returns the selection page.
	 * @return SelectionPage
	 */
	protected SelectionPage getSelectionPage()
	{
		return selectionPage;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
	 */
	protected void initPages()
	{
		selectionPage = new SelectionPage("selectionPage", getWorkbench(), getSelection(), wizardElements, message); //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		addPage(getSelectionPage());
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish()
	{
		getSelectionPage().saveWidgetValues();
		return true;
	}
}
