/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Container.java,v 1.1 2005/04/29 09:22:09 dguilbaud Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.util;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;

/**
 * Created by @author pnedelec
 *
 */
public class Container {
    private ListenerList containerListeners = new ListenerList(3);

    public void addContainerListener(IContainerListener listener) {
        containerListeners.add(listener);
    }

    public void removeContainerListener(IContainerListener listener) {
        containerListeners.remove(listener);
    }

    /**
     * Programatical invocation of a container change.
     */
    public void contentsChanged() {
        Object[] listeners = containerListeners.getListeners();
        for (int i = 0, max = listeners.length; i < max; ++i) {
            final IContainerListener l = (IContainerListener) listeners[i];
            Platform.run(new SafeRunnable() {
                public void run() {
                    l.containerModified();
                }

                public void handleException(Throwable e) {
                    super.handleException(e);
                    removeContainerListener(l);
                }
            });
        }
    }

}