/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ILabelAndDescriptionProvider.java,v 1.2 2005/02/25 22:17:20 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.util;

import org.eclipse.jface.viewers.ILabelProvider;

/**
 * Extends <code>ILabelProvider</code> with a method
 * to provide the text for the description of a given element. 
 * 
 * @author marcelop
 * @since 0.0.1
 */
public interface ILabelAndDescriptionProvider
extends ILabelProvider
{
	/**
	 * Returns the text for the description of the given element.
	 * @param element the element for which to provide the description text
	 * @return the text string used to label the element, or <code>null</code>
	 * if there is no description for the given object
	 */
	public String getDescription(Object element);
}
