/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.widgets.grapher;

/**
 * A basic graph source interface depicting x slider data only.
 * 
 * @author gchristelis
 * @since 4.0.0
 */
public interface BasicGraphSource 
{	
    /**
     * The positive infinity constant
     */
	public static final double POSITIVE_INFINITY = Double.POSITIVE_INFINITY;

    /**
     * The negative infinity constant
     */    
	public static final double NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;
	
	/**
	 * Get the minimum time this graph has data at
	 * @return the minimum time this graph has data at
	 */
	public double getMin();

	/**
	 * Get the maximum time this graph has data at
	 * @return the maximum time this graph has data at
	 */
	public double getMax();

}