/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.widgets.grapher;

/**
 * A graph source describing a collection of points. Adds to the 
 * <code>BasicGraphSource</code> interface by providing the ability to query
 * specific y values assocuated with any x value.
 * 
 * @author gchristelis
 * @since 4.0.0
 */
public interface EnumerationGraphSource extends BasicGraphSource 
{		
	/**
	 * Get the value at or immediately before the provided time
	 * @param x the time to get the value at
	 * @return the value at or immediately before the provided time
	 */
	public Object getValueAt(double x);
}