/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.widgets.grapher;

/**
 * The GraphHighlighter interface highlights or unhighlights a graph in the Graph
 * Canvas. The highlight behaviour is arbitrary and often dependent on the Graph
 * implementation. 
 * 
 * @author gchristelis
 * @since 4.0.0
 */

public interface GraphHighlighter 
{
    /**
     * Highlight a graph
     * @param g the Graph implementation to highlight
     */
	public void setHighlight(Graph g);
    
    /**
     * UnHighlight a graph
     * @param g the Graph implementation to no longer highlight
     */    
	public void unsetHighlight(Graph g);	
}