/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.widgets.grapher;

/**
 * Graph selection source implementations notify the graph canvas of the currently 
 * selected graph. 
 * 
 * @author gchristelis
 * @since 4.0.0
 */
public interface GraphSelectionSource 
{
    /**
     * Return the currently selected Graph instance.
     * 
     * @return the currently selected graph, or <code>null</code> if none is selected
     */
	public Graph getSelectedGraph();
}