/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.widgets.grapher;

/**
 * The IndicatorSource defines the necessary methods and indicator source
 * types used to plot indicators on ZoomSliders
 * 
 * An Indicator plots the resulting y value for a specific x time on the 
 * y axis slider. The indicator source provides the indicator values to plot 
 * on the sliders.
 * 
 * @author gchristelis
 * @since 4.0.0
 * @see org.eclipse.hyades.ui.widgets.grapher.IndicatorSource
 */
public interface IndicatorSource 
{    
    /**
     * The Time source type constant.<br><br>
     * 
     * Defines the indicator location double to be a time value in milliseconds.
     */
	public static final int TYPE_TIME = 0;
    
    /**
     * The Pixel source type constant.<br><br>
     * 
     * Defines the indicator location double to be a pixel value.
     */    
	public static final int TYPE_PIXEL = 1;
    
    /** 
     * Return the IndicatorSource type. The indicator source returns an indicator location
     * double value. This constant type defines this double value type. Possible values are
     * <li>TYPE_TIME</li>
     * <li>TYPE_PIXEL</li>
     *  
     * @return an integer constant representing this source type
     */
	public int getSourceType();
    
    /**
     * Get the location to be used in drawing the indicators. This indicator
     * location type is defined by the <code>getSourceType</code>.
     * 
     * @return the current indicator location
     */
	public double getIndicatorLocation();
}