/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.widgets.grapher;

import org.eclipse.swt.graphics.GC;

/**
 * A text graph interface extends the Graph interface so that the canvas 
 * can provide a y offset to render text on the canvas so that text graphs
 * are assured of not overlapping.
 * 
 * @author gchristelis 
 * @since 4.0.0
 */
public interface TextGraph extends Graph 
{
    /**
     * Responsible for drawing the instance of this Graph on the canvas, and
     * displaying text at a particular offset.
     * 
     * @param gc an SWT GC on which the implemented graph should be drawn
     * @param x the x coordinate bound, in pixels
     * @param y the y coordinate bound, in pixels
     * @param w the width of the drawing canvas, in pixels
     * @param h the height of the drawing canvas, in pixels 
     * @param y_offset the y offset that text will be drawn from
     * @return the extent of the drawn text
     */
	public int paintGraph(GC gc, int x, int y, int w, int h, int y_offset);
}