/**********************************************************************
 * Copyright (c) 2005, 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.widgets.grapher.graphs;

import org.eclipse.hyades.ui.widgets.grapher.BasicGraphSource;
import org.eclipse.hyades.ui.widgets.grapher.EnumerationGraphSource;
import org.eclipse.hyades.ui.widgets.grapher.Graph;
import org.eclipse.hyades.ui.widgets.grapher.GraphCanvas;
import org.eclipse.hyades.ui.widgets.grapher.IndicatorSource;
import org.eclipse.hyades.ui.widgets.grapher.TextGraph;
import org.eclipse.hyades.ui.widgets.zoomslider.TimeZoomSlider;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSlider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

/**
 * The enumeration graph extend textgraph and is responsible for
 * displaying a vertical line and associated text on the canvas.
 * 
 * @author gchristelis
 * @since 4.0.0
 */
public class EnumerationGraph implements TextGraph 
{
    private static Color black_color; 
    
    private double xoffset = 0;
    private double yoffset = 0;
    
    private double xdelta = 0;
    private double ydelta = 0;

    private String name, description, misc;

    private TimeZoomSlider xslider;
    private ZoomSlider yslider;
	
    private Color fg_col;
    private int line_width = 1;
    private int line_style = SWT.LINE_SOLID;
    
    private EnumerationGraphSource source;    
		
	/**
	 * Graphs the reference lines for a pair of sliders
	 * @param xslider this graphs associated xslider
	 * @param yslider this graphs associated yslider
	 * @param col the color of this graph
	 * @param source the graph source for this enumeration graph 
	 */
	public EnumerationGraph(TimeZoomSlider xslider, ZoomSlider yslider, Color col, EnumerationGraphSource source) 
    {
		this.xslider = xslider;
		this.yslider = yslider;
		
		this.fg_col = col;
		
		this.source = source;
	}
    
    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setIndicatorSource(org.eclipse.hyades.ui.widgets.grapher.IndicatorSource)
     */
    public void setIndicatorSource(IndicatorSource isource) 
    {
    }   
    	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getGraphSource()
	 */
	public BasicGraphSource getGraphSource() {
		return source;	
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getXMin()
	 */
	public double getXMin() {
		return source.getMin();		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getXMax()
	 */
	public double getXMax() {
		return source.getMax();
	}


	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getYMin()
	 */
	public double getYMin() {
		return Double.NEGATIVE_INFINITY;		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getYMax()
	 */
	public double getYMax() {
		return Double.POSITIVE_INFINITY;		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getXSlider()
	 */
	public TimeZoomSlider getXSlider() {
		return xslider;	
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getYSlider()
	 */
	public ZoomSlider getYSlider() {
		return yslider;	
	}	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setXSlider(org.eclipse.hyades.ui.widgets.zoomslider.TimeZoomSlider)
	 */
	public void setXSlider(TimeZoomSlider slider) {
		xslider = slider;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setYSlider(org.eclipse.hyades.ui.widgets.zoomslider.ZoomSlider)
	 */
	public void setYSlider(ZoomSlider slider) {
		yslider = slider;
	}	
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setForeground(org.eclipse.swt.graphics.Color)
	 */
	public void setForeground(Color col) {
		fg_col = col;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getForeground()
	 */
	public Color getForeground() {
		return fg_col;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setLineWidth(int)
	 */
	public void setLineWidth(int w) {
		line_width = w;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getLineWidth()
	 */
	public int getLineWidth() {
		return line_width;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setLineStyle(int)
	 */
	public void setLineStyle(int swt_line_style) {
		line_style = swt_line_style;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getLineStyle()
	 */
	public int getLineStyle() {
		return line_style;	
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#paintGraph(org.eclipse.swt.graphics.GC, int, int, int, int)
	 */
	public void paintGraph(GC gc, int x, int y, int w, int h) {
		paintGraph(gc,x,y,w,h,0);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.TextGraph#paintGraph(org.eclipse.swt.graphics.GC, int, int, int, int, int)
	 */
	public int paintGraph(GC gc, int x, int y, int w, int h, int stroffset) {

		int yoffset = stroffset;
		int fheight = gc.getFontMetrics().getHeight();
	
		gc.setForeground(fg_col);
		gc.setLineWidth(line_width);	
		gc.setLineStyle(line_style);

		Object prev = null;
		for (int i = x; i < x+w; i++) {
			double t = xslider.pixel2Value(i);
			if ( t >= source.getMin() && t <= source.getMax() ) {
				Object str = source.getValueAt(t);

				if (str != prev && !str.equals(prev)) {

					gc.setForeground(fg_col);

					gc.drawLine(i,y,i,y+h);

					gc.drawString(str.toString(),i+2,yoffset + y+1,true);

					try {
					    gc.setForeground(yslider.getDisplay().getSystemColor(SWT.COLOR_BLACK));
					} catch (Throwable xx) {
						if (black_color == null) { 
						    black_color = new Color(yslider.getDisplay(),0,0,0);
						}
						gc.setForeground(black_color);
					}
					gc.drawString(str.toString(),i+1,yoffset + y,true);

					yoffset += fheight;
					
					if ((yoffset + fheight) > h) {
						yoffset = 0;
					}	
					
				}
				prev = str;
			}
		}

		return yoffset;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setStaticScaling(double)
	 */
	public void setStaticScaling(double mult) {
	}
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getStaticScaling()
	 */
	public double getStaticScaling() {
		return 1.0;
	} 

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getPlottingType()
	 */
	public int getPlottingType() {
		return Graph.PLOTTING_TYPE_AVERAGE;
	}
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setPlottingType(int)
	 */
	public void setPlottingType(int type) {
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setPlottingPeriod(int, double)
	 */
	public void setPlottingPeriod(int type, double value) {
	}
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getPlottingPeriodType()
	 */
	public int getPlottingPeriodType() {
		return Graph.PERIOD_TYPE_TICKS;
	}
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getPlottingPeriodValue()
	 */
	public double getPlottingPeriodValue() {
		return 1.0;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setXOffset(double)
	 */
	public void setXOffset(double millis) {
		xoffset = millis;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getXOffset()
	 */
	public double getXOffset() {
		return xoffset;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setYOffset(double)
	 */
	public void setYOffset(double millis) {
		yoffset = millis;
	}
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getYOffset()
	 */
	public double getYOffset() {
		return yoffset;
	}	
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getNoDataBehaviour()
	 */
	public int getNoDataBehaviour() {
		return Graph.NODATA_DO_NOTHING;
	}
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setNoDataBehaviour(int)
	 */
	public void setNoDataBehaviour(int i) {
	}
    
    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setName(java.lang.String)
     */
    public void setName(String name)
    { 
        this.name = name;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getName()
     */
    public String getName()
    {
        return name;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setDescription(java.lang.String)
     */
    public void setDescription(String description)
    {
        this.description = description;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getDescription()
     */
    public String getDescription()
    {
        return description;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setMisc(java.lang.String)
     */
    public void setMisc(String misc)
    {
        this.misc = misc;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getMisc()
     */
    public String getMisc()
    {
        return misc;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setGraphCanvas(org.eclipse.hyades.ui.widgets.grapher.GraphCanvas)
     */
    public void setGraphCanvas(GraphCanvas gc)
    {
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getGraphCanvas()
     */
    public GraphCanvas getGraphCanvas()
    {
        return null;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#dispose()
     */
    public void dispose()
    {
        // TODO Auto-generated method stub
        
    }

	public void setXDelta(double millis) 
	{
		xdelta = millis;
	}

	public double getXDelta() 
	{
		return xdelta;	
	}

	public void setYDelta(double millis) 
	{
		ydelta = millis;
	}

	public double getYDelta() 
	{
		return ydelta;
	}

}