/**********************************************************************
 * Copyright (c) 2005, 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.widgets.grapher.graphs;

import java.util.Vector;

import org.eclipse.hyades.ui.widgets.grapher.BasicGraphSource;
import org.eclipse.hyades.ui.widgets.grapher.Graph;
import org.eclipse.hyades.ui.widgets.grapher.GraphCanvas;
import org.eclipse.hyades.ui.widgets.grapher.IndicatorSource;
import org.eclipse.hyades.ui.widgets.zoomslider.TimeZoomSlider;
import org.eclipse.hyades.ui.widgets.zoomslider.TimeZoomSliderTick;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSlider;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderTick;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

/**
 * A sample Graph implementation that draws references grid lines on a Graph Canvas for a set
 * of sliders. Grid lines are either <code>major</code> or <code>minor</code> where major line graphs
 * are emphasized and typically represent more substrantial points on the sliders.
 * 
 * This graph implementation can be added to a Graph Canvas to get grid lines
 *  
 * @author gchristelis
 * @since 4.0.0
 */
public class ReferenceLineGraph implements Graph 
{	
	private TimeZoomSlider xslider;
    private ZoomSlider yslider;
    private Color fg_col;
    private boolean major;
    private int line_width = 1;
    private int line_style = SWT.LINE_DOT;
	
	/**
	 * Graphs a major or minor reference line for a pair of sliders, in a particular color.
     * 
     * @param xslider the xslider to reference
     * @param yslider the yslider to reference
     * @param col the color of the reference graph line
     * @param major true if this is a major reference line, false if it is a minor
	 */
	public ReferenceLineGraph(TimeZoomSlider xslider, ZoomSlider yslider, Color col, boolean major) 
    {
		this.xslider = xslider;
		this.yslider = yslider;
		
		this.fg_col = col;
		this.major = major;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getGraphSource()
	 */
	public BasicGraphSource getGraphSource()
{
		return null;	
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setIndicatorSource(org.eclipse.hyades.ui.widgets.grapher.IndicatorSource)
	 */
	public void setIndicatorSource(IndicatorSource isource) 
    {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getXMin()
	 */
	public double getXMin() 
    {
		return Double.NEGATIVE_INFINITY;		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getXMax()
	 */
	public double getXMax() 
    {
		return Double.POSITIVE_INFINITY;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getYMin()
	 */
	public double getYMin() 
    {
		return Double.NEGATIVE_INFINITY;		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getYMax()
	 */
	public double getYMax() 
    {
		return Double.POSITIVE_INFINITY;		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getXSlider()
	 */
	public TimeZoomSlider getXSlider() 
    {
		return xslider;	
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getYSlider()
	 */
	public ZoomSlider getYSlider() 
    {
		return yslider;	
	}	
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setXSlider(org.eclipse.hyades.ui.widgets.zoomslider.TimeZoomSlider)
	 */
	public void setXSlider(TimeZoomSlider slider) 
    {
		xslider = slider;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setYSlider(org.eclipse.hyades.ui.widgets.zoomslider.ZoomSlider)
	 */
	public void setYSlider(ZoomSlider slider) 
    {
		yslider = slider;
	}	
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setForeground(org.eclipse.swt.graphics.Color)
	 */
	public void setForeground(Color col) 
    {
		fg_col = col;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getForeground()
	 */
	public Color getForeground() 
    {
		return fg_col;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setLineWidth(int)
	 */
	public void setLineWidth(int w) 
    {
		line_width = w;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getLineWidth()
	 */
	public int getLineWidth() 
    {
		return line_width;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setLineStyle(int)
	 */
	public void setLineStyle(int swt_line_style) 
    {
		line_style = swt_line_style;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getLineStyle()
	 */
	public int getLineStyle() 
    {
		return line_style;	
	}	

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#paintGraph(org.eclipse.swt.graphics.GC, int, int, int, int)
	 */
	public void paintGraph(GC gc, int xorigin, int yorigin, int w, int h) 
    {		
		gc.setForeground(fg_col);
		gc.setLineWidth(line_width);	
        
        gc.setLineStyle(SWT.LINE_SOLID);

		Vector yticks = yslider.getTickVector();

		double xres = xslider.getIncrement();
		double yres = yslider.getIncrement();
		
		double ystart = yslider.getMinVisible()-yres;
		double yend = yslider.getMaxVisible()+yres;

		Vector xticks = xslider.getTickVector();

		double xstart = xslider.getMinVisible()-xres;
		double xend = xslider.getMaxVisible()+xres;

		int px1, px2, py1, py2;

		px1 = (int)xslider.value2Pixel(xstart);
		px2 = (int)xslider.value2Pixel(xend);
		for (int tick = 0; tick < yticks.size(); tick++) {
			ZoomSliderTick ytick = (ZoomSliderTick)yticks.get(tick);
			if (ytick.getTextVisibleBoolean() && major) {
				py1 = (int)yslider.value2Pixel(ytick.getValue());
				gc.drawLine(xorigin+px1,yorigin+py1,xorigin+px2,yorigin+py1);		
			} else if (!ytick.getTextVisibleBoolean() && !major) {
				py1 = (int)yslider.value2Pixel(ytick.getValue());
				gc.drawLine(xorigin+px1,yorigin+py1,xorigin+px2,yorigin+py1);		
			}
		}

		py1 = (int)yslider.value2Pixel(ystart);
		py2 = (int)yslider.value2Pixel(yend);
		for (int tick = 0; tick < xticks.size(); tick++) {
			TimeZoomSliderTick xtick = (TimeZoomSliderTick)xticks.get(tick);
			if (xtick.getTextVisibleBoolean() && major) {
				px1 = (int)xslider.value2Pixel(xtick.getValue());
				gc.drawLine(xorigin+px1,yorigin+py1,xorigin+px1,yorigin+py2);
			} else if (!xtick.getTextVisibleBoolean() && !major) {
				px1 = (int)xslider.value2Pixel(xtick.getValue());
				gc.drawLine(xorigin+px1,yorigin+py1,xorigin+px1,yorigin+py2);
			}

		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setStaticScaling(double)
	 */
	public void setStaticScaling(double mult) {
	}
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getStaticScaling()
	 */
	public double getStaticScaling() {
		return 1.0;
	} 
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getPlottingType()
	 */
	public int getPlottingType() 
    {
		return Graph.PLOTTING_TYPE_AVERAGE;
	}
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setPlottingType(int)
	 */
	public void setPlottingType(int type) 
    {
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setPlottingPeriod(int, double)
	 */
	public void setPlottingPeriod(int type, double value) 
    {
	}
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getPlottingPeriodType()
	 */
	public int getPlottingPeriodType() 
    {
		return Graph.PERIOD_TYPE_TICKS;
	}
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getPlottingPeriodValue()
	 */
	public double getPlottingPeriodValue() 
    {
		return 1.0;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setXOffset(double)
	 */
	public void setXOffset(double millis) 
    {
	}
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getXOffset()
	 */
	public double getXOffset() 
    {
		return 0;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setYOffset(double)
	 */
	public void setYOffset(double millis) 
    {
	}
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getYOffset()
	 */
	public double getYOffset() 
    {
		return 0;
	}		
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getNoDataBehaviour()
	 */
	public int getNoDataBehaviour() 
    {
		return Graph.NODATA_DO_NOTHING;
	}
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setNoDataBehaviour(int)
	 */
	public void setNoDataBehaviour(int i) 
    {
	}
    
    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setName(java.lang.String)
     */
    public void setName(String name)
    { 
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getName()
     */
    public String getName()
    {
        return null;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setDescription(java.lang.String)
     */
    public void setDescription(String description)
    {
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getDescription()
     */
    public String getDescription()
    {
        return null;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setMisc(java.lang.String)
     */
    public void setMisc(String misc)
    {
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getMisc()
     */
    public String getMisc()
    {
        return null;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#setGraphCanvas(org.eclipse.hyades.ui.widgets.grapher.GraphCanvas)
     */
    public void setGraphCanvas(GraphCanvas gc)
    {
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#getGraphCanvas()
     */
    public GraphCanvas getGraphCanvas()
    {
        return null;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.widgets.grapher.Graph#dispose()
     */
    public void dispose()
    {
        if (fg_col.isDisposed() == false)
            fg_col.dispose();
    }

	public void setXDelta(double millis) {
		// TODO Auto-generated method stub
		
	}

	public double getXDelta() {
		// TODO Auto-generated method stub
		return 0;
	}

	public void setYDelta(double millis) {
		// TODO Auto-generated method stub
		
	}

	public double getYDelta() {
		// TODO Auto-generated method stub
		return 0;
	}

}